/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.notebooks.JupyterSecurityService;
import com.dataiku.dip.notebooks.exports.JupyterExport;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.BackendAPITicketService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DKUIOUtils;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JupyterExportService {
    private static final int EXPORT_EXECUTE_CELL_TIMEOUT = 60;
    @Autowired
    IJupyterService jupyterService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    BackendAPITicketService apiTicketService;
    @Autowired
    InsecureProcessesLaunchService insecureProcessesLaunchService;
    @Autowired
    JupyterSecurityService jupyterSecurityService;
    @Autowired
    ProjectsService projectsService;
    static Logger logger = Logger.getLogger((String)"dku.insights.jupyter");

    private static List<String> getGenerateNotebookExportCmd(File notebookPath, boolean execute, int cellTimeout) {
        String pythonBin = System.getenv("DKUPYTHONBIN");
        if (pythonBin == null) {
            throw new RuntimeException("environment variable DKUPYTHONBIN not defined");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(new File(pythonBin).getAbsolutePath());
        cmd.add("-u");
        cmd.add("-m");
        cmd.add("nbconvert");
        if (execute) {
            cmd.add("--execute");
            cmd.add("--NotebookApp.login_handler_class=notebook.dataiku.security.DataikuJupyterSecurity");
            if (cellTimeout > 0) {
                cmd.add("--ExecutePreprocessor.timeout=" + cellTimeout);
            }
        }
        cmd.add(notebookPath.getAbsolutePath());
        cmd.add("--to");
        cmd.add("html");
        cmd.add("--stdout");
        return cmd;
    }

    public String generateHtml(AuthCtx authCtx, String projectKey, String notebook, boolean execute, int cellTimeout) throws Exception {
        File notebookFile;
        CodeEnvModel.UsedCodeEnvRef codeEnv;
        HashSet relevantProjectKeys = Sets.newHashSet((Object[])new String[]{projectKey});
        try (Transaction t = this.transactionService.beginRead();){
            List<? extends DatasetLocUtils.DatasetLoc> exposedDatasets = this.projectsService.getExposedDatasets(projectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : exposedDatasets) {
                relevantProjectKeys.add(datasetLoc.getProjectKey());
            }
            RelFile rf = this.jupyterService.getNotebookFile(projectKey, notebook);
            JsonObject jsonObject = (JsonObject)t.readObjectUnsafe(rf, JsonObject.class);
            JupyterCodeEnvUtils.NotebookCodeEnvInfo kernelInfo = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(jsonObject);
            codeEnv = kernelInfo != null && kernelInfo.envLang != null ? new CodeEnvModel.UsedCodeEnvRef(kernelInfo.envLang, kernelInfo.envName) : null;
            notebookFile = this.jupyterService.isNotebookWithOutputsUpToDate(projectKey, notebook) ? this.jupyterService.getNotebookWithOutputsFile(projectKey, notebook) : this.jupyterService.getNotebookFileAsFile(projectKey, notebook);
        }
        String exportRunId = "export-" + SecretKeyGenerator.generate((int)8);
        JupyterSecurityService.JupyterKernelContext context = this.jupyterSecurityService.createContext(projectKey, notebook, authCtx, relevantProjectKeys, exportRunId, null, codeEnv);
        APITicketService.Ticket ticket = this.apiTicketService.getTicket(context.ticketSecret);
        assert (ticket != null);
        try {
            String string;
            AutoDelete autoDelete = new AutoDelete(new File(context.processRunDir));
            try {
                JupyterSecurityService.JupyterKernelSparkContext sparkContext = new JupyterSecurityService.JupyterKernelSparkContext();
                String notebookCopyName = "nbk_" + exportRunId + ".ipynb";
                DKUFileUtils.mkdirs((File)new File((File)autoDelete, "dss-template"));
                DKUFileUtils.writeFileUTF8((File)new File((File)autoDelete, "dss-template/conf.json"), (String)"{\n    \"base_template\": \"classic\",\n    \"mimetypes\": {\n        \"text/html\": true\n    }\n}");
                String templateStr = DKUIOUtils.getResourceFileContent(JupyterExportService.class, "ipython_tmpl.tpl");
                templateStr = templateStr.replace("extends 'basic.tpl'", "extends 'classic/index.html.j2'");
                DKUFileUtils.writeFileUTF8((File)new File((File)autoDelete, "dss-template/index.html.j2"), (String)templateStr);
                File notebookFileCopy = new File((File)autoDelete, notebookCopyName);
                logger.debug((Object)("Copying ipynb to " + notebookFileCopy.getAbsolutePath() + " where it can be accessed"));
                FileUtils.copyFile((File)notebookFile, (File)notebookFileCopy);
                notebookFile = notebookFileCopy;
                List<String> cmd = JupyterExportService.getGenerateNotebookExportCmd(notebookFile, execute, cellTimeout);
                DKUFileUtils.copyDirectory((File)DKUApp.getResourceFile((String[])new String[]{"jupyter", "nbconvert-templates"}), (File)autoDelete, EnumSet.of(DKUFileUtils.CopyDirectoryFlags.NoPreserveFileDate), (FileFilter[])new FileFilter[0]);
                cmd.add("--TemplateExporter.template_paths=" + autoDelete.getAbsolutePath());
                cmd.add("--TemplateExporter.template_paths=" + new File((File)autoDelete, "dss-template").getAbsolutePath());
                cmd.add("--TemplateExporter.template_paths=" + new File((File)autoDelete, "base").getAbsolutePath());
                cmd.add("--TemplateExporter.template_paths=" + new File((File)autoDelete, "basic").getAbsolutePath());
                cmd.add("--TemplateExporter.template_paths=" + new File((File)autoDelete, "classic").getAbsolutePath());
                cmd.add("--TemplateExporter.extra_template_basedirs=" + autoDelete.getAbsolutePath());
                cmd.add("--template");
                cmd.add("dss-template");
                logger.info((Object)("Export notebook with command : " + Joiner.on((String)" ").join(cmd)));
                logger.info((Object)("Export notebook in : " + autoDelete.getAbsolutePath()));
                ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                processBuilder.environment().put("PYTHONIOENCODING", "utf-8");
                processBuilder.environment().put("DKU_CURRENT_PROJECT_KEY", projectKey);
                processBuilder.environment().put("DKU_API_TICKET", ticket.getSecret());
                processBuilder.environment().put("DKU_CALL_ORIGIN", "notebook");
                if (StringUtils.isNotBlank((String)sparkContext.pysparkSubmitArgs)) {
                    processBuilder.environment().put("PYSPARK_SUBMIT_ARGS", sparkContext.pysparkSubmitArgs);
                }
                if (StringUtils.isNotBlank((String)sparkContext.sparkrSubmitArgs)) {
                    processBuilder.environment().put("SPARKR_SUBMIT_ARGS", sparkContext.sparkrSubmitArgs);
                }
                if (StringUtils.isNotBlank((String)sparkContext.toreeSubmitArgs)) {
                    processBuilder.environment().put("TOREE_SUBMIT_ARGS", sparkContext.toreeSubmitArgs);
                }
                if (StringUtils.isNotBlank((String)sparkContext.sparklyrConfig)) {
                    processBuilder.environment().put("DKU_SPARKLYR_CONFIG", sparkContext.sparklyrConfig);
                }
                List<String> additionalPythonPath = context.pythonPath;
                if (StringUtils.isNotBlank((String)sparkContext.pysparkPythonPath)) {
                    additionalPythonPath.add(sparkContext.pysparkPythonPath);
                }
                Object pythonPath = System.getenv("PYTHONPATH");
                if (additionalPythonPath.size() > 0) {
                    pythonPath = (String)pythonPath + File.pathSeparator + StringUtils.join(additionalPythonPath, (String)File.pathSeparator);
                }
                processBuilder.environment().put("PYTHONPATH", (String)pythonPath);
                processBuilder.environment().put("DKU_SOURCE_LIB_R_PATH", StringUtils.join(context.rsrcPath, (String)File.pathSeparator));
                if (StringUtils.isNotBlank((String)sparkContext.sparkHome)) {
                    processBuilder.environment().put("SPARK_HOME", sparkContext.sparkHome);
                }
                logger.debug((Object)("Generate insight from notebook : " + StringUtils.join(processBuilder.command(), (String)" ")));
                DKUtils.ErrorCollectingExecCompletionHandler completionHandler = new DKUtils.ErrorCollectingExecCompletionHandler("Jupyter notebook creation failed");
                DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
                DKUtils.ExecOutputConsumer consumer = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)outputCollector).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)completionHandler);
                final IsolableProcess p = this.insecureProcessesLaunchService.launch(authCtx, projectKey, GeneralSettingsDAO.CGrouppableProcessType.JUPYTER_KERNEL, (File)autoDelete, processBuilder);
                consumer.start(p.getInputStream(), p.getErrorStream(), p.getOutputStream());
                try (FutureAborter.AutoCloseableAbortHook abortHook = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            p.evilKill();
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Unable to stop notebook export", (Throwable)e);
                        }
                    }
                });){
                    int rv = p.waitFor();
                    completionHandler.handle(rv);
                }
                catch (ProcessDiedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Process failure", e);
                }
                finally {
                    consumer.finish();
                }
                string = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        autoDelete.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Error when joining stderr/stdout thread reader.", interruptedException);
                }
                catch (Exception exception) {
                    logger.error((Object)"Notebook export failed", (Throwable)exception);
                    throw exception;
                }
            }
            autoDelete.close();
            return string;
        }
        finally {
            this.apiTicketService.expireTicket(ticket);
        }
    }

    public JupyterExport create_NT(AuthCtx authCtx, String projectKey, String notebook, boolean execute) throws Exception {
        return this.create_NT(authCtx, projectKey, notebook, execute, 0);
    }

    public JupyterExport create_NT(AuthCtx authCtx, String projectKey, String notebook, boolean execute, int cellTimeout) throws Exception {
        if (cellTimeout <= 0) {
            cellTimeout = ApplicationConfigurator.getParams().getIntParam("dku.jupyterExport.cellTimeout", Integer.valueOf(60));
        }
        this.checkNotebookExistence(projectKey, notebook);
        JupyterExport export = new JupyterExport(projectKey, notebook);
        File insightHtmlFile = this.getExportFile(projectKey, notebook, export.timestamp);
        export.html = this.generateHtml(authCtx, projectKey, notebook, execute, cellTimeout);
        FileUtils.writeStringToFile((File)insightHtmlFile, (String)export.html, (String)"UTF-8");
        return export;
    }

    public JupyterExport get_NT(String projectKey, String notebook, long timestamp) throws Exception {
        this.checkNotebookExistence(projectKey, notebook);
        File insightHtmlFile = this.getExportFile(projectKey, notebook, timestamp);
        String html = FileUtils.readFileToString((File)insightHtmlFile);
        JupyterExport export = new JupyterExport(projectKey, notebook, timestamp, html);
        return export;
    }

    public JupyterExport getLast_NT(String projectKey, String notebook) throws Exception {
        JupyterExport export = new JupyterExport(projectKey, notebook);
        this.checkNotebookExistence(projectKey, notebook);
        File exportDir = this.getExportsDir(projectKey, notebook);
        File[] exportFiles = exportDir.listFiles();
        if (exportFiles == null) {
            return null;
        }
        Arrays.sort(exportFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Collections.reverse(Arrays.asList(exportFiles));
        for (File f : exportFiles) {
            String fileName = FilenameUtils.removeExtension((String)f.getName());
            if (!f.isFile() || !FilenameUtils.getExtension((String)f.getName()).equals("html") || !fileName.matches("\\d*")) continue;
            export.html = FileUtils.readFileToString((File)f);
            export.timestamp = Long.parseLong(fileName);
            break;
        }
        return export;
    }

    public List<JupyterExport> list_NT(String projectKey, String notebook, boolean withContent) throws Exception {
        ArrayList<JupyterExport> list = new ArrayList<JupyterExport>();
        this.checkNotebookExistence(projectKey, notebook);
        File exportDir = this.getExportsDir(projectKey, notebook);
        Object[] exportFiles = exportDir.listFiles();
        if (exportFiles == null) {
            return list;
        }
        Arrays.sort(exportFiles);
        Collections.reverse(Arrays.asList(exportFiles));
        for (Object f : exportFiles) {
            String fileName = FilenameUtils.removeExtension((String)((File)f).getName());
            if (!((File)f).isFile() || !FilenameUtils.getExtension((String)((File)f).getPath()).equals("html") || !fileName.matches("\\d*")) continue;
            String html = !withContent ? "" : FileUtils.readFileToString((File)f);
            long timestamp = Long.parseLong(fileName);
            JupyterExport export = new JupyterExport(projectKey, notebook, timestamp, html);
            list.add(export);
        }
        return list;
    }

    private void checkNotebookExistence(String projectKey, String notebook) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            RelFile notebookFile = this.jupyterService.getNotebookFile(projectKey, notebook);
            if (!t.exists(notebookFile)) {
                throw new NotFoundException("Notebook does not exist");
            }
        }
    }

    private File getExportsDir(String projectKey, String name) {
        return ApplicationConfigurator.getFile((String[])new String[]{"exports", "jupyter-notebooks", projectKey, name});
    }

    private File getExportFile(String projectKey, String name, long timestamp) {
        return new File(this.getExportsDir(projectKey, name), timestamp + ".html");
    }

    public class PythonExecutionException
    extends IOException {
        private static final long serialVersionUID = -7714166966336846308L;
        private String errorLog;

        PythonExecutionException(String message, String errorLog) {
            super(message);
            this.errorLog = errorLog;
        }

        public String getErrorLog() {
            return this.errorLog;
        }
    }
}

