/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dao.ModelEvaluationComparatorsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightHandler;
import com.dataiku.dip.dashboards.insights.InsightsRegistry;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.FlowZone;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.kernel.master.BuildState;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.KnowledgeBankManagementService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.datasets.DataStewardService;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.datasets.DatasetsCRUDController;
import com.dataiku.dip.server.services.DatasetNotebookService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NavigatorService {
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private DatasetNotebookService notebookService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDBService;
    @Autowired
    private BuildState buildState;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private ModelEvaluationComparatorsDAO modelEvaluationComparatorsDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private ClusteringSMMgmtService clusteringSMMgmtService;
    @Autowired
    private LLMSMMgmtService llmSMMgmtService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    @Autowired
    private CodeStudioTemplatesService codeStudioTemplatesService;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private KernelsModelEvaluationStoresService kernelsModelEvaluationStoresService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private CodeStudioRuntimeManager codeStudioRuntimeManager;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DataStewardService dataStewardService;
    @Autowired
    private KnowledgeBankManagementService kbMgmtService;
    static Logger logger = Logger.getLogger((String)"dku.navigator.service");

    private List<Workspace> getWorkspacesWhereSharedUnsafe(@Nullable AuthCtx authCtx, String projectKey, String id, ITaggingService.TaggableType type) throws Exception {
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        if (authCtx == null) {
            return workspaces;
        }
        block0: for (Workspace workspace : this.workspacesService.listAccessibleWorkspacesUnsafe(authCtx)) {
            for (Workspace.WorkspaceObject workspaceObject : workspace.workspaceObjects) {
                if (workspaceObject.reference == null || !workspaceObject.reference.type.equals((Object)type) || !workspaceObject.reference.id.equals(id) || !workspaceObject.reference.projectKey.equals(projectKey)) continue;
                workspaces.add(workspace);
                continue block0;
            }
        }
        return workspaces;
    }

    public ObjectContext getObjectContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        switch (obj.type) {
            case DATASET: {
                return this.getDatasetContext(obj, true);
            }
            case STREAMING_ENDPOINT: {
                return this.getStreamingEndpointContext(obj);
            }
            case SAVED_MODEL: {
                return this.getSavedModelContext(obj);
            }
            case MODEL_EVALUATION_STORE: {
                return this.getModelEvaluationStoreContext(obj);
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return this.getRetrievableKnowledgeContext(obj);
            }
            case MANAGED_FOLDER: {
                return this.getManagedFolderContext(obj);
            }
            case RECIPE: {
                return this.getRecipeContext(obj);
            }
            case LABELING_TASK: {
                return this.getLabelingTaskContext(obj);
            }
            case ANALYSIS: {
                return this.getAnalysisContext(obj);
            }
            case STATISTICS_WORKSHEET: {
                return this.getWorksheetContext(obj);
            }
            case JUPYTER_NOTEBOOK: {
                return this.getJupyterNotebookContext(obj);
            }
            case SQL_NOTEBOOK: {
                return this.getSQLNotebookContext(obj);
            }
            case SEARCH_NOTEBOOK: {
                return this.getSearchNotebookContext(obj);
            }
            case INSIGHT: {
                return this.getInsightContext(obj);
            }
            case PROJECT: 
            case LAMBDA_SERVICE: 
            case SCENARIO: 
            case DASHBOARD: 
            case WEB_APP: 
            case CODE_STUDIO: 
            case MODEL_COMPARISON: 
            case DATA_COLLECTION: {
                throw new NotImplementedException();
            }
        }
        return null;
    }

    private ObjectContext getSQLNotebookContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        SQLNotebook notebook = (SQLNotebook)this.sqlNotebooksDAO.getMandatoryUnsafe(obj.projectKey, obj.id);
        ObjectContext context = new ObjectContext("sqlNotebook_" + obj.id, obj.projectKey);
        NotebookFullInfo notebookFullInfo = new NotebookFullInfo();
        notebookFullInfo.notebook = notebook;
        context.nodes.put("sqlNotebook_" + obj.id, notebookFullInfo);
        return context;
    }

    private ObjectContext getSearchNotebookContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        SearchNotebook notebook = (SearchNotebook)this.searchNotebooksDAO.getMandatoryUnsafe(obj.projectKey, obj.id);
        ObjectContext context = new ObjectContext("searchNotebook_" + obj.id, obj.projectKey);
        NotebookFullInfo notebookFullInfo = new NotebookFullInfo();
        notebookFullInfo.notebook = notebook;
        context.nodes.put("searchNotebook_" + obj.id, notebookFullInfo);
        return context;
    }

    private ObjectContext getJupyterNotebookContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        ObjectContext context;
        JupyterUtils.JupyterNotebookListEntry notebook = this.jupyterService.getOrNullUnsafe(obj.projectKey, obj.id);
        NotebookFullInfo notebookInfo = new NotebookFullInfo();
        notebookInfo.notebook = notebook;
        if (StringUtils.isNotBlank((String)notebook.analyzedDataset)) {
            context = this.getDatasetContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ITaggingService.TaggableType.DATASET, notebook.analyzedDataset), false);
            notebookInfo.datasetNodeId = GraphIds.forDatasetSM(obj.projectKey, notebook.analyzedDataset);
        } else if (StringUtils.isNotBlank((String)notebook.associatedRecipe)) {
            context = this.getRecipeContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ITaggingService.TaggableType.RECIPE, notebook.associatedRecipe));
            notebookInfo.recipeNodeId = GraphIds.forRecipe(notebook.associatedRecipe);
        } else {
            context = new ObjectContext();
        }
        notebookInfo.timeline = new TimelinesService.TimelineWithVersioning();
        notebookInfo.timeline.createdBy.login = notebook.creator;
        context.focusNodeId = "jupyterNotebook_" + obj.id;
        context.nodes.put("jupyterNotebook_" + obj.id, notebookInfo);
        return context;
    }

    public AnalysisFullInfo getAnalysisFullInfo(String projectKey, String analysisId) throws IOException {
        AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatoryUnsafe(projectKey, analysisId);
        AnalysisFullInfo info = new AnalysisFullInfo();
        info.analysis = acp;
        info.datasetNodeId = GraphIds.forDatasetSM(projectKey, acp.inputDatasetSmartName);
        info.mlTasks = this.analysisCRUDService.listMLTasks(projectKey, analysisId, true);
        return info;
    }

    private ObjectContext getAnalysisContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatoryUnsafe(obj.projectKey, obj.id);
        ObjectContext context = this.getDatasetContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ITaggingService.TaggableType.DATASET, acp.inputDatasetSmartName), false);
        AnalysisFullInfo analysisInfo = this.getAnalysisFullInfo(obj.projectKey, obj.id);
        context.nodes.put("analysis_" + obj.id, analysisInfo);
        context.focusNodeId = "analysis_" + obj.id;
        return context;
    }

    public WorksheetFullInfo getWorksheetFullInfo(Worksheet worksheet) throws IOException {
        WorksheetFullInfo info = new WorksheetFullInfo();
        info.worksheet = worksheet;
        info.datasetNodeId = GraphIds.forDatasetSM(worksheet.projectKey, worksheet.dataSpec.inputDatasetSmartName);
        return info;
    }

    private ObjectContext getWorksheetContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        Worksheet worksheet = this.worksheetsService.getWorksheet(obj.projectKey, obj.id);
        ObjectContext context = this.getDatasetContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ITaggingService.TaggableType.DATASET, worksheet.dataSpec.inputDatasetSmartName), false);
        WorksheetFullInfo worksheetInfo = this.getWorksheetFullInfo(worksheet);
        context.nodes.put("worksheet_" + obj.id, worksheetInfo);
        context.focusNodeId = "worksheet_" + obj.id;
        return context;
    }

    private ObjectContext getInsightContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        InsightFullInfo insightFullInfo = this.getInsightFullInfo(obj.projectKey, obj.id, null);
        List<InsightHandler.RequiredPermission> requiredPermissions = InsightsRegistry.buildHandler(insightFullInfo.insight).getRequiredPermissions();
        SmartObjectRef ref = requiredPermissions.get((int)0).objectRef;
        ObjectContext context = new ObjectContext();
        if (ref.objectType == ITaggingService.TaggableType.DATASET) {
            context = this.getDatasetContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ref.objectType, ref.getSmartName()), false);
            context.centerNodeId = GraphIds.forDataset(ref.getProjectKey(obj.projectKey), ref.objectId);
        } else if (ref.objectType == ITaggingService.TaggableType.SAVED_MODEL) {
            context = this.getSavedModelContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ref.objectType, ref.getSmartName()));
            context.centerNodeId = GraphIds.forSavedModel(ref.getProjectKey(obj.projectKey), ref.objectId);
        } else if (ref.objectType == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            context = this.getModelEvaluationStoreContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ref.objectType, ref.getSmartName()));
            context.centerNodeId = GraphIds.forModelEvaluationStore(ref.getProjectKey(obj.projectKey), ref.objectId);
        } else if (ref.objectType == ITaggingService.TaggableType.MANAGED_FOLDER) {
            context = this.getManagedFolderContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ref.objectType, ref.getSmartName()));
            context.centerNodeId = GraphIds.forManagedFolder(ref.getProjectKey(obj.projectKey), ref.objectId);
        } else if (ref.objectType == ITaggingService.TaggableType.STREAMING_ENDPOINT) {
            context = this.getStreamingEndpointContext(new TaggableObjectsService.TaggableObjectRef(obj.projectKey, ref.objectType, ref.getSmartName()));
            context.centerNodeId = GraphIds.forStreamingEndpoint(ref.getProjectKey(obj.projectKey), ref.objectId);
        } else if (ref.objectType == ITaggingService.TaggableType.JUPYTER_NOTEBOOK) {
            NotebookFullInfo notebookInfo = new NotebookFullInfo();
            notebookInfo.notebook = this.jupyterService.getOrNullUnsafe(ref.getProjectKey(obj.projectKey), ref.objectId);
            context.nodes.put("jupyterNotebook_" + ref.getSmartName(), notebookInfo);
            context.centerNodeId = "jupyterNotebook_" + ref.getSmartName();
        }
        context.nodes.put("insight_" + obj.id, insightFullInfo);
        context.focusNodeId = "insight_" + obj.id;
        return context;
    }

    private ObjectContext getDatasetContext(TaggableObjectsService.TaggableObjectRef obj, boolean fullInfo) throws Exception {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(obj.projectKey, obj.id);
        String graphId = GraphIds.forDataset(loc.getProjectKey(), loc.getName());
        ObjectContext context = new ObjectContext(graphId, obj.projectKey);
        if (fullInfo) {
            SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
            DatasetFullInfo info = this.getDatasetFullInfo(loc, context.projectKey, null, serializedDataset);
            context.nodes.put(graphId, info);
            if ("JobsDB".equals(info.dataset.type)) {
                return this.addMetricsDatasetContext(context, info);
            }
        } else {
            context.nodes.put(graphId, this.getDatasetLightInfo(loc, context.projectKey));
        }
        this.addComputableContext(context, loc);
        return context;
    }

    private ObjectContext addMetricsDatasetContext(ObjectContext context, DatasetFullInfo info) throws Exception {
        JobsdbDatasetParams params = info.dataset.getParamsAs(JobsdbDatasetParams.class);
        if (params.scope != JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT || StringUtils.isBlank((String)params.smartName)) {
            return context;
        }
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(context.projectKey, params.smartName);
        if (dataset != null) {
            String graphId;
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(context.projectKey, params.smartName);
            info.datasetNodeId = graphId = GraphIds.forDataset(loc.getProjectKey(), loc.getName());
            context.nodes.put(graphId, this.getDatasetLightInfo(loc, context.projectKey));
            this.addComputableContext(context, loc);
            return context;
        }
        return context;
    }

    private ObjectContext getStreamingEndpointContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(obj.projectKey, obj.id);
        String graphId = GraphIds.forStreamingEndpoint(loc.getProjectKey(), loc.getId());
        ObjectContext context = new ObjectContext(graphId, obj.projectKey);
        context.nodes.put(graphId, this.getStreamingEndpointFullInfo(loc, obj.projectKey, null));
        this.addComputableContext(context, loc);
        return context;
    }

    private ObjectContext getManagedFolderContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(obj.projectKey, obj.id);
        String graphId = GraphIds.forManagedFolder(loc.getProjectKey(), loc.getId());
        ObjectContext context = new ObjectContext(graphId, obj.projectKey);
        context.nodes.put(graphId, this.getManagedFolderFullInfo(loc, obj.projectKey, null));
        this.addComputableContext(context, loc);
        return context;
    }

    private ObjectContext getSavedModelContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(obj.projectKey, obj.id);
        String graphId = GraphIds.forSavedModel(loc.getProjectKey(), loc.getId());
        ObjectContext context = new ObjectContext(graphId, obj.projectKey);
        context.nodes.put(graphId, this.getSavedModelFullInfo(loc, obj.projectKey));
        this.addComputableContext(context, loc);
        return context;
    }

    private ObjectContext getModelEvaluationStoreContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(obj.projectKey, obj.id);
        String graphId = GraphIds.forModelEvaluationStore(loc.getProjectKey(), loc.getId());
        ObjectContext context = new ObjectContext(graphId, obj.projectKey);
        context.nodes.put(graphId, this.getModelEvaluationStoreFullInfo(loc, obj.projectKey));
        this.addComputableContext(context, loc);
        return context;
    }

    private ObjectContext getRetrievableKnowledgeContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(obj.projectKey, obj.id);
        String graphId = GraphIds.forRetrievableKnowledge(loc.getProjectKey(), loc.getId());
        ObjectContext context = new ObjectContext(graphId, obj.projectKey);
        context.nodes.put(graphId, this.getRetrievableKnowledgeFullInfo(loc, obj.projectKey));
        this.addComputableContext(context, loc);
        return context;
    }

    private ObjectContext getLabelingTaskContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(obj.projectKey, obj.id);
        String graphId = GraphIds.forLabelingTask(loc.getProjectKey(), loc.getId());
        ObjectContext context = new ObjectContext(graphId, obj.projectKey);
        context.nodes.put(graphId, this.getLabelingTaskFullInfo(obj.projectKey, obj.id));
        this.addComputableContext(context, loc);
        return context;
    }

    private ObjectContext getRecipeContext(TaggableObjectsService.TaggableObjectRef obj) throws Exception {
        ProjectFlowGraph graph = this.flowGraphService.getProjectGraphUnsafe(obj.projectKey);
        FlowRecipe flowRecipe = graph.getRecipe(obj.projectKey, obj.id);
        ObjectContext context = new ObjectContext(GraphIds.forRecipe(flowRecipe), obj.projectKey);
        this.addRecipeFullInfo(context, flowRecipe);
        if (flowRecipe.getSuccessors() != null) {
            for (FlowComputable target : flowRecipe.getTargets()) {
                this.addComputableLightInfo(context, target);
            }
        }
        if (flowRecipe.getPredecessors() != null) {
            for (FlowComputable src : flowRecipe.getSources()) {
                this.addComputableLightInfo(context, src);
            }
        }
        return context;
    }

    private ObjectContext addComputableContext(ObjectContext context, AnyLoc loc) throws Exception {
        FlowComputable computableUnsafe = this.flowGraphService.getProjectGraphUnsafe(context.projectKey).getComputable(loc.getProjectKey() + "." + loc.getId());
        if (computableUnsafe == null) {
            return context;
        }
        return this.addComputableContext(context, computableUnsafe);
    }

    private ObjectContext addComputableContext(ObjectContext context, FlowComputable flowComputable) throws Exception {
        if (flowComputable.getSuccessors() != null) {
            for (GraphNode graphNode : flowComputable.getSuccessors()) {
                if (!(graphNode instanceof FlowRecipe)) continue;
                for (FlowComputable target : ((FlowRecipe)graphNode).getTargets()) {
                    this.addComputableLightInfo(context, target);
                }
            }
        }
        if (flowComputable.getPredecessors() != null) {
            for (GraphNode graphNode : flowComputable.getPredecessors()) {
                if (!(graphNode instanceof FlowRecipe)) continue;
                for (FlowComputable src : ((FlowRecipe)graphNode).getSources()) {
                    this.addComputableLightInfo(context, src);
                }
            }
        }
        return context;
    }

    private void addComputableLightInfo(ObjectContext context, FlowComputable flowComputable) throws Exception {
        if (flowComputable instanceof FlowDataset) {
            String graphId = GraphIds.forComputable(flowComputable);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(((FlowDataset)flowComputable).getFullName());
            context.nodes.put(graphId, this.getDatasetLightInfo(loc, context.projectKey));
        }
    }

    private void addInfo(TaggableObjectFullInfo info) throws Exception {
        try {
            TaggableObjectsService.TaggableObject to = info.getTaggableObject();
            if (to.versionTag != null) {
                info.versioning.lastModifiedBy = this.usersService.getPublicUser(to.versionTag.getLastAuthor());
                info.versioning.lastModifiedOn = to.versionTag.getLastModifiedOn();
            } else {
                logger.trace((Object)(String.valueOf((Object)to.getTaggableType()) + " " + to.getFullId() + " has no version tag"));
            }
            if (to.creationTag != null) {
                info.versioning.createdBy = this.usersService.getPublicUser(to.creationTag.getLastAuthor());
                info.versioning.createdOn = to.creationTag.getLastModifiedOn();
            } else {
                logger.trace((Object)(String.valueOf((Object)to.getTaggableType()) + " " + to.getFullId() + " has no creation tag"));
            }
        }
        catch (Throwable e) {
            logger.info((Object)"Failed to get edition info", e);
        }
    }

    public void addInfo_NT(TaggableObjectFullInfo info, AuthCtx u) {
        TaggableObjectsService.TaggableObject to = info.getTaggableObject();
        try {
            info.timeline = this.timelinesService.getObjectTimeline_NT(to, 0, 10);
            if (info.versioning.lastModifiedOn < info.timeline.lastModifiedOn) {
                info.versioning.lastModifiedOn = info.timeline.lastModifiedOn;
                info.versioning.lastModifiedBy = info.timeline.lastModifiedBy;
            }
        }
        catch (Throwable e) {
            logger.info((Object)"Failed to get timeline", e);
        }
        try {
            info.interest = this.interestsService.getObjectAndUserInterest_NT(u, to.getTaggableType(), to.getProjectKey(), to.getId(), null);
        }
        catch (Throwable e) {
            logger.info((Object)"Failed to get interests", e);
        }
        if (info instanceof ComputableFullInfo) {
            try {
                ComputableFullInfo cInfo = (ComputableFullInfo)info;
                cInfo.lastBuild = this.jobsDBService.getLatestBuildForObject(new TaggableObjectsService.TaggableObjectRef(info.getTaggableObject()));
            }
            catch (Throwable e) {
                logger.info((Object)"Failed to get last build info", e);
            }
        }
        if (info instanceof ModelEvaluationStoreFullInfo) {
            try {
                ModelEvaluationStoreFullInfo mesInfo = (ModelEvaluationStoreFullInfo)info;
                mesInfo.evaluations = this.kernelsModelEvaluationStoresService.listEvaluations(mesInfo.evaluationStore);
            }
            catch (Throwable e) {
                logger.info((Object)"Failed to list model evaluations", e);
            }
        }
        if (info instanceof RecipeFullInfo) {
            try {
                RecipeFullInfo rInfo = (RecipeFullInfo)info;
                if (rInfo.continuous) {
                    rInfo.continuousState = this.continuousActivitiesManager.getStateOrNull(info.getTaggableObject().getProjectKey(), info.getTaggableObject().getId());
                }
            }
            catch (Throwable e) {
                logger.info((Object)"Failed to get continuous activity info", e);
            }
        }
        if (info instanceof CodeStudioObjectFullInfo) {
            try {
                CodeStudioObjectFullInfo kInfo = (CodeStudioObjectFullInfo)info;
                kInfo.uiState = this.codeStudioRuntimeManager.getState(u, kInfo.codeStudioObject);
            }
            catch (Throwable e) {
                logger.info((Object)"Failed to get Code Studio info", e);
            }
        }
    }

    private void addComputableInfo(ComputableFullInfo info, FlowComputable flowComputable) throws Exception {
        this.addInfo(info);
        if (flowComputable == null) {
            return;
        }
        info.recipes = new HashSet<DatasetsCRUDController.RecipeLink>();
        for (GraphNode graphNode : flowComputable.getSuccessors()) {
            if (!(graphNode instanceof FlowRunnable) || graphNode instanceof FlowImplicitRecipe) continue;
            FlowRunnable runnable = (FlowRunnable)graphNode;
            DatasetsCRUDController.RecipeLink rl = new DatasetsCRUDController.RecipeLink();
            rl.projectKey = runnable.getProjectKey();
            rl.name = runnable.getName();
            rl.id = runnable.getId();
            rl.type = runnable.getType();
            info.recipes.add(rl);
        }
        if (flowComputable.getPredecessors().size() == 1 && flowComputable.getPredecessors().get(0) instanceof FlowRunnable && !(flowComputable.getPredecessors().get(0) instanceof FlowImplicitRecipe)) {
            FlowRunnable predecessor = (FlowRunnable)flowComputable.getPredecessors().get(0);
            if (predecessor instanceof FlowRecipe) {
                if (RecipeRegistry.getMeta(((FlowRecipe)predecessor).getModel()).isContinuous()) {
                    info.continuousBuildable = true;
                } else {
                    info.buildable = true;
                    info.upstreamBuildable = true;
                }
            }
            DatasetsCRUDController.RecipeLink recipeLink = new DatasetsCRUDController.RecipeLink();
            recipeLink.projectKey = predecessor.getProjectKey();
            recipeLink.name = predecessor.getName();
            recipeLink.id = predecessor.getId();
            recipeLink.type = predecessor.getType();
            if (info.buildable) {
                info.creatingRecipe = recipeLink;
            } else if (info.continuousBuildable) {
                info.creatingContinuousRecipe = recipeLink;
            } else if (predecessor instanceof FlowLabelingTask) {
                info.creatingLabelingTask = recipeLink;
            }
        }
        info.downstreamBuildable = flowComputable.getSuccessors().stream().filter(successor -> {
            if (successor instanceof FlowRecipe) {
                return !RecipeRegistry.getMeta(((FlowRecipe)successor).getModel()).isContinuous();
            }
            return false;
        }).count() > 0L;
    }

    private void addPrivilegeInfo(ComputableFullInfo info, @Nullable AuthCtx user, AnyLoc loc, ITaggingService.TaggableType type) throws DKUSecurityException, IOException {
        if (user == null) {
            return;
        }
        info.objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(loc.getProjectKey(), loc.getId(), type, user);
    }

    public ManagedFolderFullInfo getManagedFolderFullInfo(AnyLoc loc, String contextProjectKey, @Nullable AuthCtx user) throws Exception {
        ManagedFolderFullInfo info = new ManagedFolderFullInfo();
        info.folder = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
        FlowManagedFolder flowManagedFolder = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey).getFolder(info.folder.projectKey, info.folder.id);
        this.addComputableInfo(info, flowManagedFolder);
        this.addPrivilegeInfo(info, user, loc, ITaggingService.TaggableType.MANAGED_FOLDER);
        return info;
    }

    public StreamingEndpointFullInfo getStreamingEndpointFullInfo(AnyLoc loc, String contextProjectKey, @Nullable AuthCtx user) throws Exception {
        StreamingEndpointFullInfo info = new StreamingEndpointFullInfo();
        info.streamingEndpoint = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
        FlowStreamingEndpoint fse = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey).getStreamingEndpoint(info.streamingEndpoint.projectKey, info.streamingEndpoint.id);
        this.addComputableInfo(info, fse);
        if (info.streamingEndpoint.getType().equals("kafka")) {
            DSSConnection conn;
            KafkaStreamingEndpointParams params = info.streamingEndpoint.getParamsAs(KafkaStreamingEndpointParams.class);
            if (StringUtils.isNotBlank((String)params.connection) && (conn = ConnectionsDAO.get().getConnection(user, params.connection)) != null) {
                info.connectionCanKsql = StringUtils.isNotBlank((String)((KafkaConnection)conn).params.ksqlConnectionParams.serverUrl);
            }
        }
        return info;
    }

    public DatasetFullInfo getDatasetFullInfo_NT(AnyLoc datasetLoc, String contextProjectKey, @Nullable AuthCtx user) throws Exception {
        DatasetFullInfo info;
        SerializedDataset serializedDataset;
        try (Transaction t = this.transactionService.beginRead();){
            serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(datasetLoc);
            info = this.getDatasetFullInfo(datasetLoc, contextProjectKey, user, serializedDataset);
        }
        this.addDatasetInfo_NT(info, serializedDataset);
        this.addInfo_NT(info, user);
        return info;
    }

    public DatasetFullInfo getDatasetFullInfo(AnyLoc datasetLoc, String contextProjectKey, @Nullable AuthCtx user, SerializedDataset serializedDataset) throws Exception {
        String dsSmartName = datasetLoc.getSmartName(contextProjectKey);
        DatasetFullInfo dsInfo = new DatasetFullInfo(serializedDataset);
        dsInfo.analyses = this.analysisCRUDService.listCoreUnsafe(contextProjectKey, dsSmartName);
        dsInfo.charts = this.exploresService.listChartsForDatasetUnsafe(contextProjectKey, dsSmartName);
        dsInfo.notebooks = this.notebookService.listDatasetNotebooksUnsafe(contextProjectKey, dsSmartName);
        dsInfo.worksheets = this.worksheetsService.listWorksheetHeads(contextProjectKey, dsSmartName);
        dsInfo.currentBuildState = this.buildState.getDatasetBuildState(datasetLoc.getProjectKey(), datasetLoc.getId());
        dsInfo.workspaces = this.getWorkspacesWhereSharedUnsafe(user, datasetLoc.getProjectKey(), datasetLoc.getId(), ITaggingService.TaggableType.DATASET);
        dsInfo.dataSteward = this.dataStewardService.getDataStewardUser(serializedDataset);
        dsInfo.defaultDataSteward = this.dataStewardService.getDefaultDataStewardUser_safe(serializedDataset);
        FlowDataset flowDataset = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey).getDataset(datasetLoc.getProjectKey(), datasetLoc.getId());
        this.addComputableInfo(dsInfo, flowDataset);
        this.addPrivilegeInfo(dsInfo, user, datasetLoc, ITaggingService.TaggableType.DATASET);
        return dsInfo;
    }

    public DatasetFullInfo getDatasetPublicInfo(AnyLoc datasetLoc, @Nullable AuthCtx user) throws Exception {
        SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(datasetLoc);
        DatasetFullInfo dsInfo = new DatasetFullInfo(serializedDataset);
        dsInfo.currentBuildState = this.buildState.getDatasetBuildState(datasetLoc.getProjectKey(), datasetLoc.getId());
        this.addPrivilegeInfo(dsInfo, user, datasetLoc, ITaggingService.TaggableType.DATASET);
        dsInfo.dataSteward = this.dataStewardService.getDataStewardUser(serializedDataset);
        dsInfo.defaultDataSteward = this.dataStewardService.getDefaultDataStewardUser_safe(serializedDataset);
        return dsInfo;
    }

    public void addDatasetInfo_NT(DatasetFullInfo dsInfo, SerializedDataset sd) throws Exception {
        dsInfo.status = this.datasetMetricsStatusService.getCachedSummaryStatus(Dataset.fromSerializedUnsafe(sd.getFullName(), sd));
        if (dsInfo.status.size.totalValue == -1L && dsInfo.status.records.totalValue == -1L) {
            dsInfo.status = null;
        }
        dsInfo.dataQualityStatus = this.dataQualityService.getDatasetStatusLast_NT(sd);
    }

    public DatasetLightContextInfo getDatasetLightInfo(DatasetLocUtils.DatasetLoc datasetLoc, String contextProjectKey) throws Exception {
        DatasetLightContextInfo dsInfo = new DatasetLightContextInfo();
        String smartName = datasetLoc.getSmartName(contextProjectKey);
        dsInfo.numAnalyses = this.analysisCRUDService.listHeadsUnsafe(contextProjectKey, smartName).size();
        dsInfo.numCharts = this.exploresService.listChartsForDatasetUnsafe(contextProjectKey, smartName).size();
        dsInfo.numNotebooks = this.notebookService.listDatasetNotebooksUnsafe(contextProjectKey, smartName).size();
        return dsInfo;
    }

    public SavedModelFullInfo getSavedModelFullInfo(AnyLoc loc, String contextProjectKey) throws Exception {
        return this.getSavedModelFullInfo(loc, contextProjectKey, null);
    }

    public SavedModelFullInfo getSavedModelFullInfo(AnyLoc loc, String contextProjectKey, @Nullable AuthCtx user) throws Exception {
        SavedModelFullInfo info = new SavedModelFullInfo();
        info.model = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
        FlowSavedModel flowSavedModel = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey).getModel(info.model.projectKey, info.model.id);
        this.addComputableInfo(info, flowSavedModel);
        this.addPrivilegeInfo(info, user, loc, ITaggingService.TaggableType.SAVED_MODEL);
        return info;
    }

    public void addSavedModelStatus_NT(SavedModelFullInfo smInfo) {
        SavedModel sm = smInfo.model;
        switch (sm.getType()) {
            case PREDICTION: {
                smInfo.status = this.predictionSMMgmtService.getStatus_NT(sm);
                break;
            }
            case CLUSTERING: {
                smInfo.status = this.clusteringSMMgmtService.getStatus_NT(sm);
                break;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                smInfo.status = LLMSMMgmtService.getStatus_NT(sm);
            }
        }
    }

    public ModelEvaluationStoreFullInfo getModelEvaluationStoreFullInfo(AnyLoc loc, String contextProjectKey) throws Exception {
        return this.getModelEvaluationStoreFullInfo(loc, contextProjectKey, null);
    }

    public ModelEvaluationStoreFullInfo getModelEvaluationStoreFullInfo(AnyLoc loc, String contextProjectKey, @Nullable AuthCtx user) throws Exception {
        ModelEvaluationStoreFullInfo info = new ModelEvaluationStoreFullInfo();
        info.evaluationStore = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
        FlowModelEvaluationStore flowModelEvaluationStore = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey).getEvaluationStore(info.evaluationStore.projectKey, info.evaluationStore.id);
        this.addComputableInfo(info, flowModelEvaluationStore);
        this.addPrivilegeInfo(info, user, loc, ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
        return info;
    }

    public ModelComparisonFullInfo getModelEvaluationComparatorFullInfo(String projectKey, String modelComparisonId) throws Exception {
        ModelComparisonFullInfo info = new ModelComparisonFullInfo();
        info.modelComparison = (ModelComparison)this.modelEvaluationComparatorsDAO.getMandatoryUnsafe(projectKey, modelComparisonId);
        return info;
    }

    public RetrievableKnowledgeFullInfo getRetrievableKnowledgeFullInfo(AnyLoc loc, String contextProjectKey) throws Exception {
        return this.getRetrievableKnowledgeFullInfo(loc, contextProjectKey, null);
    }

    public RetrievableKnowledgeFullInfo getRetrievableKnowledgeFullInfo(AnyLoc loc, String contextProjectKey, @Nullable AuthCtx user) throws Exception {
        RetrievableKnowledgeFullInfo info = new RetrievableKnowledgeFullInfo();
        info.retrievableKnowledge = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
        String currentVersion = this.kbMgmtService.getCurrentlyUsedVersion(info.retrievableKnowledge);
        this.kbMgmtService.readKnowledgeBankFolder(info.retrievableKnowledge, currentVersion, folder -> {
            File statusFile = DKUApp.getFile((File)folder, (String[])new String[]{"kb_status.json"});
            if (statusFile.exists()) {
                info.status = (RetrievableKnowledge.RetrievableKnowledgeStatus)JSON.parseFile((File)statusFile, RetrievableKnowledge.RetrievableKnowledgeStatus.class);
            }
        });
        FlowRetrievableKnowledge flowRetrievableKnowledge = this.flowGraphService.getProjectGraphUnsafe(contextProjectKey).getRetrievableKnowledge(info.retrievableKnowledge.projectKey, info.retrievableKnowledge.id);
        this.addComputableInfo(info, flowRetrievableKnowledge);
        this.addPrivilegeInfo(info, user, loc, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE);
        return info;
    }

    public PromptStudioFullInfo getPromptStudioFullInfo(String projectKey, String promptStudioId) throws Exception {
        PromptStudioFullInfo info = new PromptStudioFullInfo();
        info.promptStudio = (PromptStudio)this.promptStudioDAO.getMandatoryUnsafe(projectKey, promptStudioId);
        return info;
    }

    public AgentToolFullInfo getAgentToolFullInfo(String projectKey, String agentToolId) throws Exception {
        AgentToolFullInfo info = new AgentToolFullInfo();
        info.agentTool = (AgentTool)this.agentToolsDAO.getMandatoryUnsafe(projectKey, agentToolId);
        return info;
    }

    public CreatingRecipeFullInfo getCreatingRecipe(String projectKey, ITaggingService.TaggableType computableType, String computableId) throws IOException {
        ProjectFlowGraph projectGraph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        FlowComputable flowComputable = null;
        switch (computableType) {
            case DATASET: {
                flowComputable = projectGraph.getDataset(projectKey, computableId);
                break;
            }
            case SAVED_MODEL: {
                flowComputable = projectGraph.getModel(projectKey, computableId);
                break;
            }
            case MODEL_EVALUATION_STORE: {
                flowComputable = projectGraph.getEvaluationStore(projectKey, computableId);
                break;
            }
            case MANAGED_FOLDER: {
                flowComputable = projectGraph.getFolder(projectKey, computableId);
                break;
            }
            case STREAMING_ENDPOINT: {
                flowComputable = projectGraph.getStreamingEndpoint(projectKey, computableId);
                break;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                flowComputable = projectGraph.getRetrievableKnowledge(projectKey, computableId);
            }
        }
        if (flowComputable != null) {
            CreatingRecipeFullInfo creatingRecipeFullInfo = new CreatingRecipeFullInfo();
            creatingRecipeFullInfo.computableProjectKey = projectKey;
            creatingRecipeFullInfo.computableId = computableId;
            creatingRecipeFullInfo.computableType = flowComputable.getType();
            List<? extends GraphNode> predecessors = flowComputable.getPredecessors();
            if (predecessors.size() == 1 && predecessors.get(0) instanceof FlowRunnable && !(predecessors.get(0) instanceof FlowImplicitRecipe)) {
                FlowRunnable runnable = (FlowRunnable)predecessors.get(0);
                creatingRecipeFullInfo.creatingRecipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(runnable.getProjectKey(), runnable.getName());
            }
            return creatingRecipeFullInfo;
        }
        return null;
    }

    public RecipeFullInfo getRecipeFullInfo(String projectKey, String name) throws Exception {
        RecipeFullInfo info = new RecipeFullInfo();
        info.recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, name);
        info.script = this.recipesDAO.getPayloadOrNull(projectKey, name);
        info.notebook = this.notebookService.getRecipeNotebookUnsafe(projectKey, name);
        FlowRecipe flowRecipe = this.flowGraphService.getProjectGraphUnsafe(projectKey).getRecipe(projectKey, name);
        if (flowRecipe != null) {
            ObjectLink link;
            for (FlowComputable src : flowRecipe.getSources()) {
                link = this.getComputableLink(src, projectKey);
                info.inputs.put(link.id, link);
            }
            for (FlowComputable target : flowRecipe.getTargets()) {
                link = this.getComputableLink(target, projectKey);
                info.outputs.put(link.id, link);
            }
            info.continuous = RecipeRegistry.getMeta(flowRecipe.getModel()).isContinuous();
        }
        info.lastBuild = this.getRecipeLastBuild(info.recipe);
        this.addInfo(info);
        return info;
    }

    @Nullable
    public ReadOnlyJobsInternalDB.ObjectBuild getRecipeLastSuccessfulBuild(SerializedRecipe recipe) throws SQLException {
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getFlatOutputs();
        if (!outputs.isEmpty()) {
            return this.jobsDBService.getLatestSuccessfulBuildForObject(recipe.projectKey, outputs.get((int)0).ref);
        }
        return null;
    }

    @Nullable
    private ReadOnlyJobsInternalDB.ObjectBuild getRecipeLastBuild(SerializedRecipe recipe) throws SQLException {
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getFlatOutputs();
        if (!outputs.isEmpty()) {
            return this.jobsDBService.getLatestBuildForObject(new TaggableObjectsService.TaggableObjectRef(recipe.projectKey, null, outputs.get((int)0).ref));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ZoneFullInfo getZoneFullInfo(String projectKey, String zoneId) throws Exception {
        ZoneFullInfo info = new ZoneFullInfo();
        info.zone = (Zone)this.zonesDAO.getMandatoryUnsafe(projectKey, zoneId);
        ProjectFlowGraph projectGraphUnsafe = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        FlowZone flowZone = projectGraphUnsafe.getFlowZone(zoneId);
        if (flowZone == null) {
            return info;
        }
        for (FlowComputable flowComputable : flowZone.listComputables()) {
            SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(flowComputable.getType().toTaggableType(), flowComputable.getRef(projectKey));
            String zoneIdOfComputable = this.flowZonesService.retrieveZone(projectKey, smartObjectRef);
            boolean isComputableInZone = Objects.equals(zoneIdOfComputable, zoneId);
            FlowComputable computable = projectGraphUnsafe.getComputable(flowComputable.getFullId());
            if (computable == null) continue;
            for (GraphNode graphNode : computable.getSuccessors()) {
                ObjectLink link;
                void var13_13;
                ITaggingService.TaggableType type;
                if (graphNode instanceof FlowComputable) {
                    type = ((FlowComputable)graphNode).getType().toTaggableType();
                } else if (graphNode instanceof FlowRecipe) {
                    type = ITaggingService.TaggableType.RECIPE;
                } else if (graphNode instanceof FlowLabelingTask) {
                    type = ITaggingService.TaggableType.LABELING_TASK;
                } else if (graphNode instanceof FlowImplicitRecipe) {
                    FlowComputable successor;
                    FlowComputable flowComputable2 = successor = ((FlowImplicitRecipe)graphNode).getSuccessor();
                    type = successor.getType().toTaggableType();
                } else {
                    logger.warn((Object)("Not managed type found, ignoring node:" + graphNode.toString()));
                    continue;
                }
                SmartObjectRef successorSmartObjectRef = SmartObjectRef.fromSmartName(type, var13_13.getRef(projectKey));
                String zoneIdOfSuccessor = this.flowZonesService.retrieveZone(projectKey, successorSmartObjectRef);
                boolean isSuccessorInZone = Objects.equals(zoneIdOfSuccessor, zoneId);
                if (!isSuccessorInZone && isComputableInZone) {
                    link = this.getComputableLink(flowComputable, projectKey);
                    if (info.outputs.get(link.id) != null) {
                        link.zones = info.outputs.get((Object)link.id).zones;
                    }
                    link.zones.add(zoneIdOfSuccessor);
                    info.outputs.put(link.id, link);
                }
                if (!isSuccessorInZone || isComputableInZone) continue;
                link = this.getComputableLink(flowComputable, projectKey);
                if (info.inputs.get(link.id) != null) {
                    link.zones = info.inputs.get((Object)link.id).zones;
                }
                link.zones.add(zoneIdOfSuccessor);
                info.inputs.put(GraphIds.forZone(zoneIdOfComputable, link.id), link);
            }
        }
        this.addInfo(info);
        return info;
    }

    public InsightFullInfo getInsightFullInfo(String projectKey, String id, @Nullable AuthCtx authCtx) throws Exception {
        UsersService.UIUser owner;
        InsightFullInfo info = new InsightFullInfo();
        info.insight = this.insightsService.getMandatoryUnsafe(projectKey, id);
        this.addInfo(info);
        block0: for (Dashboard dashboard : this.dashboardsService.listUnsafe(projectKey)) {
            Boolean foundPinned = false;
            Boolean foundLinked = false;
            for (DashboardPage page : dashboard.pages) {
                for (Tile tile : page.grid.tiles) {
                    if (!foundPinned.booleanValue() && tile.tileType == Tile.TileType.INSIGHT && tile.insightId != null && tile.insightId.equals(id)) {
                        info.dashboardsPinnedOn.add(new Dashboard.DashboardListItem(dashboard));
                        foundPinned = true;
                    }
                    if (!foundLinked.booleanValue() && tile.clickAction == Tile.TileClickAction.OPEN_OTHER_INSIGHT && tile.targetInsightId != null && tile.targetInsightId.equals(id)) {
                        info.dashboardsLinkedFrom.add(new Dashboard.DashboardListItem(dashboard));
                        foundLinked = true;
                    }
                    if (!foundLinked.booleanValue() || !foundPinned.booleanValue()) continue;
                    continue block0;
                }
            }
        }
        InsightHandler handler = InsightsRegistry.buildHandler(info.insight);
        List<InsightHandler.RequiredPermission> requiredPermissions = handler.getRequiredPermissions();
        if (!requiredPermissions.isEmpty()) {
            InsightHandler.RequiredPermission requiredPermission = requiredPermissions.get(0);
            SmartObjectRef objectRef = requiredPermission.objectRef;
            TaggableObjectsService.TaggableObject sourceObject = this.taggableObjectsReadService.getOrNullUnsafe(objectRef.getProjectKey(projectKey), objectRef.objectType, objectRef.objectId);
            if (sourceObject != null) {
                info.sourceObjectDisplayName = sourceObject.getDisplayName();
                if (info.insight.type.equals("dataset_table") && authCtx != null) {
                    info.referencedObjectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(sourceObject.getProjectKey(), sourceObject.getId(), ITaggingService.TaggableType.DATASET, authCtx);
                }
            } else {
                info.sourceObjectDisplayName = objectRef.objectId + " (deleted)";
            }
        }
        info.ownerDisplayName = (owner = this.usersService.getUserOrNull_NoLeak(info.insight.owner)) != null ? owner.displayName : null;
        return info;
    }

    public DashboardFullInfo getDashboardFullInfo(AuthCtx authCtx, String projectKey, String id) throws Exception {
        DashboardFullInfo ret = new DashboardFullInfo();
        ret.dashboard = this.dashboardsService.getMandatoryUnsafe(projectKey, id);
        HashSet<String> insightIds = new HashSet<String>();
        ArrayList<Insight.InsightListItem> insights = new ArrayList<Insight.InsightListItem>();
        for (DashboardPage page : ret.dashboard.pages) {
            for (Tile tile : page.grid.tiles) {
                Insight insight;
                if (tile.tileType != Tile.TileType.INSIGHT || (insight = this.insightsService.getOrNullUnsafe(projectKey, tile.insightId)) == null || insightIds.contains(insight.id)) continue;
                insights.add(new Insight.InsightListItem(insight));
                insightIds.add(insight.id);
            }
        }
        ret.insights = insights;
        ret.workspaces = this.getWorkspacesWhereSharedUnsafe(authCtx, projectKey, id, ITaggingService.TaggableType.DASHBOARD);
        UsersService.UIUser owner = this.usersService.getUserOrNull_NoLeak(ret.dashboard.owner);
        ret.ownerDisplayName = owner != null ? owner.displayName : null;
        return ret;
    }

    public CodeStudioObjectFullInfo getCodeStudioFullInfo(String projectKey, String id) throws Exception {
        CodeStudioObjectFullInfo ret = new CodeStudioObjectFullInfo();
        ret.codeStudioObject = this.codeStudioObjectsService.getMandatoryUnsafe(projectKey, id);
        CodeStudioTemplate template = this.codeStudioTemplatesService.getOrNullUnsafe(ret.codeStudioObject.templateId);
        if (template != null) {
            ret.templateType = template.type;
            if (CodeStudioRegistry.hasMeta(template)) {
                ret.desc = CodeStudioRegistry.getMeta(template).getCodeStudioType(template);
            }
        } else {
            ret.templateWasDeleted = true;
        }
        return ret;
    }

    public WebAppFullInfo getWebAppFullInfo(AuthCtx authCtx, String projectKey, String id) throws Exception {
        WebAppFullInfo ret = new WebAppFullInfo();
        ret.webapp = this.webAppsService.getMandatoryUnsafe_noCode(projectKey, id);
        ret.securityInfo = WebAppSecurityInfo.create(ret.webapp);
        ret.workspaces = this.getWorkspacesWhereSharedUnsafe(authCtx, projectKey, id, ITaggingService.TaggableType.WEB_APP);
        return ret;
    }

    public WebAppFullInfo getWebAppPublicInfo(AuthCtx authCtx, String projectKey, String id) throws Exception {
        WebAppFullInfo ret = new WebAppFullInfo();
        ret.webapp = this.webAppsService.getMandatoryUnsafe_noCode(projectKey, id);
        ret.securityInfo = WebAppSecurityInfo.createPublic(ret.webapp);
        ret.workspaces = this.getWorkspacesWhereSharedUnsafe(authCtx, projectKey, id, ITaggingService.TaggableType.WEB_APP);
        return ret;
    }

    public ReportFullInfo getReportFullInfo(String projectKey, String id) throws Exception {
        ReportFullInfo ret = new ReportFullInfo();
        ret.report = this.reportsService.getMandatoryUnsafe(projectKey, id);
        return ret;
    }

    public LabelingTaskFullInfo getLabelingTaskFullInfo(String projectKey, String id) throws Exception {
        UsersService.UIUser owner;
        LabelingTaskFullInfo info = new LabelingTaskFullInfo();
        info.labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatoryUnsafe(projectKey, id);
        FlowLabelingTask flowLabelingTask = this.flowGraphService.getProjectGraphUnsafe(projectKey).getLabelingTask(projectKey, id);
        if (flowLabelingTask != null) {
            ObjectLink link;
            for (FlowComputable src : flowLabelingTask.getSources()) {
                link = this.getComputableLink(src, projectKey);
                info.inputs.put(link.id, link);
            }
            for (FlowComputable target : flowLabelingTask.getTargets()) {
                link = this.getComputableLink(target, projectKey);
                info.outputs.put(link.id, link);
            }
        }
        info.ownerDisplayName = (owner = this.usersService.getUserOrNull_NoLeak(info.labelingTask.owner)) != null ? owner.displayName : null;
        return info;
    }

    private ObjectLink getComputableLink(FlowComputable flowComputable, String contextProjectKey) throws IOException {
        switch (flowComputable.getType()) {
            case DATASET: {
                SerializedDataset dataset = ((FlowDataset)flowComputable).getSerializedMandatoryUnsafe(this.datasetsDAO);
                ObjectLink dsLink = new ObjectLink();
                dsLink.id = DatasetLocUtils.forDataset(dataset).getSmartName(contextProjectKey);
                dsLink.projectKey = dataset.projectKey;
                dsLink.name = DatasetLocUtils.forDataset(dataset).getSmartName(contextProjectKey);
                dsLink.type = dataset.type;
                dsLink.objectType = "DATASET";
                return dsLink;
            }
            case MANAGED_FOLDER: {
                ManagedFolder folder = ((FlowManagedFolder)flowComputable).getManagedFolder();
                ObjectLink mfLink = new ObjectLink();
                mfLink.id = new AnyLoc(folder.projectKey, folder.id).getSmartName(contextProjectKey);
                mfLink.projectKey = folder.projectKey;
                mfLink.name = folder.name;
                mfLink.type = "MANAGED_FOLDER";
                mfLink.objectType = "MANAGED_FOLDER";
                return mfLink;
            }
            case SAVED_MODEL: {
                SavedModel model = ((FlowSavedModel)flowComputable).getSavedModel();
                ObjectLink smLink = new ObjectLink();
                smLink.id = new AnyLoc(model.projectKey, model.id).getSmartName(contextProjectKey);
                smLink.projectKey = model.projectKey;
                smLink.name = model.name;
                smLink.type = "SAVED_MODEL";
                smLink.objectType = "SAVED_MODEL";
                return smLink;
            }
            case MODEL_EVALUATION_STORE: {
                ModelEvaluationStore evaluationStore = ((FlowModelEvaluationStore)flowComputable).getModelEvaluationStore();
                ObjectLink mesLink = new ObjectLink();
                mesLink.id = new AnyLoc(evaluationStore.projectKey, evaluationStore.id).getSmartName(contextProjectKey);
                mesLink.projectKey = evaluationStore.projectKey;
                mesLink.name = evaluationStore.name;
                mesLink.type = "MODEL_EVALUATION_STORE";
                mesLink.objectType = "MODEL_EVALUATION_STORE";
                return mesLink;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                RetrievableKnowledge rk = ((FlowRetrievableKnowledge)flowComputable).getRetrievableKnowledge();
                ObjectLink rkLink = new ObjectLink();
                rkLink.id = new AnyLoc(rk.projectKey, rk.id).getSmartName(contextProjectKey);
                rkLink.projectKey = rk.projectKey;
                rkLink.name = rk.name;
                rkLink.type = "RETRIEVABLE_KNOWLEDGE";
                rkLink.objectType = "RETRIEVABLE_KNOWLEDGE";
                return rkLink;
            }
            case STREAMING_ENDPOINT: {
                StreamingEndpoint se = ((FlowStreamingEndpoint)flowComputable).getStreamingEndpoint();
                ObjectLink seLink = new ObjectLink();
                seLink.id = new AnyLoc(se.projectKey, se.id).getSmartName(contextProjectKey);
                seLink.projectKey = se.projectKey;
                seLink.name = se.id;
                seLink.type = se.type;
                seLink.objectType = "STREAMING_ENDPOINT";
                return seLink;
            }
        }
        throw new Error("unreachable");
    }

    private void addRecipeFullInfo(ObjectContext context, FlowRecipe flowRecipe) throws Exception {
        RecipeFullInfo info = this.getRecipeFullInfo(flowRecipe.getProjectKey(), flowRecipe.getName());
        context.nodes.put(GraphIds.forRecipe(flowRecipe), info);
    }

    public void addKernelSpecInfo() {
    }

    public static class ObjectContext {
        public String focusNodeId;
        public String centerNodeId;
        public Map<String, Object> nodes = new HashMap<String, Object>();
        public String projectKey;

        public ObjectContext() {
        }

        public ObjectContext(String focusNodeId, String projectKey) {
            this.focusNodeId = focusNodeId;
            this.projectKey = projectKey;
        }
    }

    public static class NotebookFullInfo
    extends TaggableObjectFullInfo {
        public String datasetNodeId;
        public String recipeNodeId;
        public TaggableObjectsService.TaggableObject notebook;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.notebook;
        }
    }

    public static class AnalysisFullInfo
    extends TaggableObjectFullInfo {
        public AnalysisCoreParams analysis;
        public String datasetNodeId;
        public List<AnalysisCRUDService.MLTaskHead> mlTasks;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.analysis;
        }
    }

    public static class WorksheetFullInfo
    extends TaggableObjectFullInfo {
        public Worksheet worksheet;
        public String datasetNodeId;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.worksheet;
        }
    }

    public static class InsightFullInfo
    extends TaggableObjectFullInfo {
        public Insight insight;
        public List<Dashboard.DashboardListItem> dashboardsPinnedOn = new ArrayList<Dashboard.DashboardListItem>();
        public List<Dashboard.DashboardListItem> dashboardsLinkedFrom = new ArrayList<Dashboard.DashboardListItem>();
        public String ownerDisplayName;
        public String sourceObjectDisplayName;
        public ExposedObjectsService.ObjectAuthorizations referencedObjectAuthorizations;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.insight;
        }
    }

    @UIModel
    public static class DatasetFullInfo
    extends ComputableFullInfo {
        public final String type;
        public final String name;
        public List<AnalysisCoreParams> analyses;
        public List<DatasetExploreSettings.DatasetChart> charts;
        public List<DatasetNotebookService.SimpleNotebook> notebooks;
        public List<WorksheetsService.WorksheetHead> worksheets;
        public final boolean partitioned;
        public BuildState.DatasetBuildState currentBuildState;
        public final SerializedDataset dataset;
        public DatasetMetricsStatusService.DatasetSummaryStatus status;
        public JsonObject locationInfo;
        public String datasetNodeId;
        public PublicUser dataSteward;
        public DataQualityDailyStatus dataQualityStatus;
        public PublicUser defaultDataSteward;
        public boolean isFsLike;
        public boolean isFs;
        public boolean isRepeating;
        public boolean connectionForbidPartitionsWriteToNonPartitionedTable;

        public DatasetFullInfo(SerializedDataset sd) {
            this.dataset = sd;
            this.name = sd.name;
            this.type = sd.type;
            this.partitioned = sd.partitioning != null && sd.partitioning.isPartitioned();
            this.isFsLike = DatasetInspector.isFSLike(sd);
            this.isFs = DatasetInspector.isFS(sd);
            VariablesExpansionLoopConfig config = DatasetUtils.getDatasetVeLoopConfig(sd.getParams());
            if (config != null) {
                this.isRepeating = config.isEnabled();
            }
        }

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.dataset;
        }
    }

    public static class DatasetLightContextInfo {
        public int numAnalyses;
        public int numNotebooks;
        public int numCharts;
    }

    public static class StreamingEndpointFullInfo
    extends ComputableFullInfo {
        public StreamingEndpoint streamingEndpoint;
        public boolean connectionCanKsql;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.streamingEndpoint;
        }
    }

    public static class ManagedFolderFullInfo
    extends ComputableFullInfo {
        public ManagedFolder folder;
        public ManagedFolderHandler.ManagedFolderListing files;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.folder;
        }
    }

    public static class SavedModelFullInfo
    extends ComputableFullInfo {
        public SavedModel model;
        public Object status;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.model;
        }
    }

    public static class ModelEvaluationStoreFullInfo
    extends ComputableFullInfo {
        public ModelEvaluationStore evaluationStore;
        public Object status;
        public List<AbstractModelEvaluation> evaluations;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.evaluationStore;
        }
    }

    public static class RetrievableKnowledgeFullInfo
    extends ComputableFullInfo {
        public RetrievableKnowledge retrievableKnowledge;
        public RetrievableKnowledge.RetrievableKnowledgeStatus status;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.retrievableKnowledge;
        }
    }

    public static class LabelingTaskFullInfo
    extends TaggableObjectFullInfo {
        public LabelingTask labelingTask;
        public Map<String, ObjectLink> inputs = new HashMap<String, ObjectLink>();
        public Map<String, ObjectLink> outputs = new HashMap<String, ObjectLink>();
        public String ownerDisplayName;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.labelingTask;
        }
    }

    static abstract class TaggableObjectFullInfo {
        public TimelinesService.TimelineWithVersioning timeline;
        public HeadWithVersioningInfo versioning = new HeadWithVersioningInfo();
        public InterestsInternalDB.Interest interest;
        @Nullable
        public List<Workspace> workspaces = new ArrayList<Workspace>();

        TaggableObjectFullInfo() {
        }

        public abstract TaggableObjectsService.TaggableObject getTaggableObject();
    }

    static abstract class ComputableFullInfo
    extends TaggableObjectFullInfo {
        public Set<DatasetsCRUDController.RecipeLink> recipes;
        public boolean buildable;
        public boolean continuousBuildable;
        public boolean upstreamBuildable;
        public boolean downstreamBuildable;
        public DatasetsCRUDController.RecipeLink creatingRecipe;
        public DatasetsCRUDController.RecipeLink creatingContinuousRecipe;
        public DatasetsCRUDController.RecipeLink creatingLabelingTask;
        public ReadOnlyJobsInternalDB.ObjectBuild lastBuild;
        public ExposedObjectsService.ObjectAuthorizations objectAuthorizations;

        ComputableFullInfo() {
        }
    }

    @UIModel
    public static class RecipeFullInfo
    extends TaggableObjectFullInfo {
        public SerializedRecipe recipe;
        public String script;
        public Map<String, ObjectLink> inputs = new HashMap<String, ObjectLink>();
        public Map<String, ObjectLink> outputs = new HashMap<String, ObjectLink>();
        public DatasetNotebookService.SimpleNotebook notebook;
        public boolean continuous;
        public ReadOnlyJobsInternalDB.ObjectBuild lastBuild;
        public ContinuousActivitiesManager.ContinuousActivityCurrentState continuousState;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.recipe;
        }
    }

    public static class CodeStudioObjectFullInfo
    extends TaggableObjectFullInfo {
        public CodeStudioObject codeStudioObject;
        public String templateType;
        public CodeStudioObject.CodeStudioObjectType desc;
        public CodeStudioRuntime.CodeStudioUIState uiState;
        public boolean templateWasDeleted;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.codeStudioObject;
        }
    }

    public static class ModelComparisonFullInfo
    extends TaggableObjectFullInfo {
        public ModelComparison modelComparison;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.modelComparison;
        }
    }

    public static class PromptStudioFullInfo
    extends TaggableObjectFullInfo {
        public PromptStudio promptStudio;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.promptStudio;
        }
    }

    public static class AgentToolFullInfo
    extends TaggableObjectFullInfo {
        public AgentTool agentTool;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.agentTool;
        }
    }

    public static class CreatingRecipeFullInfo {
        String computableId;
        String computableProjectKey;
        FlowComputable.FCType computableType;
        SerializedRecipe creatingRecipe;
    }

    static class ObjectLink {
        public String projectKey;
        public String id;
        public String name;
        public String type;
        public String objectType;
        public Set<String> zones = new HashSet<String>();

        ObjectLink() {
        }
    }

    public static class ZoneFullInfo
    extends TaggableObjectFullInfo {
        public Zone zone;
        public Map<String, ObjectLink> inputs = new HashMap<String, ObjectLink>();
        public Map<String, ObjectLink> outputs = new HashMap<String, ObjectLink>();

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.zone;
        }
    }

    public static class DashboardFullInfo
    extends TaggableObjectFullInfo {
        public Dashboard dashboard;
        public List<Insight.InsightListItem> insights = new ArrayList<Insight.InsightListItem>();
        public String ownerDisplayName;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.dashboard;
        }
    }

    public static class WebAppFullInfo
    extends TaggableObjectFullInfo {
        public WebApp webapp;
        public WebAppSecurityInfo securityInfo;

        @Override
        public TaggableObjectsService.TaggableObject getTaggableObject() {
            return this.webapp;
        }
    }

    public static class ReportFullInfo
    extends TaggableObjectFullInfo {
        public Report report;

        @Override
        public Report getTaggableObject() {
            return this.report;
        }
    }
}

