/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLConnection;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SQLQueryStreamService {
    private static final Pattern LONG_TYPED_HINTS = Pattern.compile("/\\*\\s*(fail_after_n_rows)\\s*=\\s*([0-9]+)\\s*\\*/");
    Cache<String, Exception> queryFailures = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    int sessionsPoolMaxSize = DKUApp.getParams().getIntParam("dku.streamingSql.maxSessions", Integer.valueOf(200));
    int sessionsPoolMaxAge = DKUApp.getParams().getIntParam("dku.streamingSql.maxAgeMn", Integer.valueOf(5));
    Cache<String, SQLStreamingSession> streamingSessions = CacheBuilder.newBuilder().maximumSize((long)this.sessionsPoolMaxSize).expireAfterAccess((long)this.sessionsPoolMaxAge, TimeUnit.MINUTES).removalListener((RemovalListener)new SQLStreamingSessionCloser()).build();
    private static Logger logger = Logger.getLogger((String)"dku.stream.sql");

    SQLQueryStreamService() {
        Timer cacheExpirationTimer = new Timer("SQLQueryCache-cleanup", true);
        long delay = 300000L;
        cacheExpirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.info((Object)("Perform routine cleanup on streaming sql queries cache (" + SQLQueryStreamService.this.streamingSessions.size() + " sessions open)"));
                SQLQueryStreamService.this.streamingSessions.cleanUp();
            }
        }, delay, delay);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractSQLConnection getConnectionForStreaming(AuthCtx authCtx, String connectionOrDatasetName, boolean findConnectionFromDataset, String dbType, DatasetsDAO datasetsDAO) throws Exception {
        AbstractSQLConnection connection;
        Object connectionName;
        if (findConnectionFromDataset) {
            DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveFull(connectionOrDatasetName);
            SerializedDataset dataset = (SerializedDataset)datasetsDAO.getMandatoryUnsafe(datasetLoc);
            if (DatasetInspector.canHiveTable(dataset)) {
                String database = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(Dataset.fromSerialized(dataset)).getSchemaNullIfBlank();
                if (database == null) {
                    throw new Exception("The hive database is not configured on the connection of dataset " + dataset.name);
                }
                connectionName = "@virtual(" + dbType + "):" + database;
            } else {
                if (!(dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig)) throw new Exception("Dataset " + connectionOrDatasetName + " is neither of SQL nor HDFS type.");
                connectionName = ((AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams()).connection;
            }
        } else {
            connectionName = connectionOrDatasetName;
        }
        if ((connection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, (String)connectionName, AbstractSQLConnection.class)).isFreelyUsableBy(authCtx)) return connection;
        throw new UnauthorizedException("You may not submit queries to this connection", "connection-usage-disallowed");
    }

    public SQLStreamingSessionInfo startStreamingSQLQuery(AbstractSQLConnection connection, String query, String preQueries, String postQueries, String extraConf, String scriptStepsData, String scriptInputSchemaData, String scriptOutputSchemaData, String scriptReportLocation, AuthCtx authCtx, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, String projectKey) throws Exception {
        List scriptSteps = StringUtils.isNotBlank((String)scriptStepsData) ? (List)JSON.parse((String)scriptStepsData, (TypeToken)new TypeToken<List<ScriptStep>>(){}) : null;
        Schema scriptInputSchema = StringUtils.isNotBlank((String)scriptInputSchemaData) ? (Schema)JSON.parse((String)scriptInputSchemaData, Schema.class) : null;
        Schema scriptOutputSchema = StringUtils.isNotBlank((String)scriptOutputSchemaData) ? (Schema)JSON.parse((String)scriptOutputSchemaData, Schema.class) : null;
        ArrayList<String> lPreQueries = new ArrayList();
        ArrayList<String> lPostQueries = new ArrayList();
        Map<String, String> extraConfMap = new HashMap<String, String>();
        if (preQueries != null) {
            lPreQueries = (List)JSON.parse((String)preQueries, JSON.StringList.class);
        }
        if (postQueries != null) {
            lPostQueries = (List)JSON.parse((String)postQueries, JSON.StringList.class);
        }
        if (extraConf != null) {
            extraConfMap = (Map)JSON.parse((String)extraConf, (TypeToken)new TypeToken<Map<String, String>>(){});
        }
        return this.startStreamingSQLQuery(connection, query, lPreQueries, lPostQueries, extraConfMap, scriptSteps, scriptInputSchema, scriptOutputSchema, scriptReportLocation, authCtx, datetimenotzReadMode, dateonlyReadMode, projectKey);
    }

    public SQLStreamingSessionInfo startStreamingSQLQuery(AbstractSQLConnection connection, String query, List<String> preQueries, List<String> postQueries, Map<String, String> extraConf, List<ScriptStep> scriptSteps, Schema scriptInputSchema, Schema scriptOutputSchema, String scriptReportLocation, AuthCtx authCtx, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, String projectKey) throws Exception {
        boolean hasResults;
        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forSqlStreaming((AuthCtx)authCtx, (String)projectKey);
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
        String[] preStatements = preQueries == null ? new String[]{} : preQueries.toArray(new String[0]);
        String[] postStatements = postQueries == null ? new String[]{} : postQueries.toArray(new String[0]);
        String queryId = UUID.randomUUID().toString();
        if (!extraConf.isEmpty()) {
            if (connection instanceof HiveConnection) {
                for (Map.Entry<String, String> entry : extraConf.entrySet()) {
                    ((HiveConnection.Params)connection.getParams()).hiveconf.add(new SimpleKeyValue(entry.getKey(), entry.getValue()));
                }
            }
            for (Map.Entry<String, String> entry : extraConf.entrySet()) {
                connection.getParams().properties.add(new AbstractSQLConnection.CustomDatabaseProperty(entry.getKey(), entry.getValue(), false));
            }
        }
        SQLConnectionProvider.SQLConnectionData connectionData = connection.getConnectionData_NT(authCtx, projectKey);
        if (scriptSteps != null && !scriptSteps.isEmpty()) {
            if (connection.getDialect() instanceof SparkSQLDialect) {
                logger.info((Object)"Apply script using Spark");
            } else {
                for (ProcessorScriptStep pss : AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(scriptSteps)) {
                    ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(pss);
                    ProcessorMeta.ProcessorCapabilitiesSummary capabilities = meta.getCapabilities(pss.params, pss.designTimeReport, connectionData.getDialect(), connection);
                    if (pss.disabled || capabilities.can(ProcessorCapabilities.SQL_TRANSLATABLE)) continue;
                    throw new IllegalArgumentException("Script step " + pss.type + " cannot be translated to SQL : " + capabilities.reasonForInability(ProcessorCapabilities.SQL_TRANSLATABLE));
                }
                logger.info((Object)"Apply script using SQL");
            }
        } else {
            scriptSteps = null;
        }
        StreamingJdbcQuery streamingJdbcQuery = new StreamingJdbcQuery(connectionData, preStatements, query, postStatements, scriptSteps, scriptInputSchema, scriptOutputSchema, scriptReportLocation, authCtx, projectKey, datetimenotzReadMode, dateonlyReadMode);
        logger.info((Object)("Start a SQL query with queryId=" + queryId));
        streamingJdbcQuery.takeResources(projectKey);
        SQLStreamingSession streamingSession = new SQLStreamingSession(streamingJdbcQuery);
        streamingSession.connInfo = connection;
        if (streamingJdbcQuery.getResultSet() != null) {
            this.streamingSessions.put((Object)queryId, (Object)streamingSession);
            hasResults = true;
        } else {
            streamingJdbcQuery.releaseResources();
            hasResults = false;
        }
        return new SQLStreamingSessionInfo(queryId, hasResults, streamingSession.schema);
    }

    public DSSConnection getConnection(String queryId) {
        SQLStreamingSession streamingSession = (SQLStreamingSession)this.streamingSessions.getIfPresent((Object)queryId);
        if (streamingSession == null) {
            throw new IllegalArgumentException("SQL streaming session " + queryId + " not found");
        }
        return streamingSession.connInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamSQLQuery(HttpServletResponse resp, AuthCtx authCtx, String queryId, DatasetReadAPIUtils.FormatDef formatDef) throws Exception {
        SQLStreamingSession streamingSession = (SQLStreamingSession)this.streamingSessions.getIfPresent((Object)queryId);
        if (streamingSession == null) {
            throw new Exception("SQL streaming session " + queryId + " is not in cache anymore");
        }
        if (streamingSession.finished) {
            throw new Exception("SQL streaming session " + queryId + " is closed");
        }
        try {
            try {
                StreamedResultSet streamedResultSet = streamingSession.query.getResultSet();
                this.streamFromResultSet(authCtx, streamedResultSet, resp, queryId, formatDef);
            }
            finally {
                this.streamingSessions.invalidate((Object)queryId);
            }
        }
        catch (Exception e) {
            if (resp.getStatus() == 200) {
                this.queryFailures.put((Object)queryId, (Object)e);
            }
            throw e;
        }
    }

    public void verifySQLQuery(String queryId) throws Exception {
        Exception exception = (Exception)this.queryFailures.getIfPresent((Object)queryId);
        logger.info((Object)("Verification call for " + queryId));
        if (exception != null) {
            logger.info((Object)("Verification has something to say: " + exception.getMessage()));
            throw exception;
        }
    }

    private void streamFromResultSet(AuthCtx authCtx, StreamedResultSet resultSet, HttpServletResponse resp, String queryId, DatasetReadAPIUtils.FormatDef fd) throws Exception {
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());
        OutputFormatter formatter = FormatFactory.buildFormatter(authCtx, null, fd.formatMeta.getType(), fd.params);
        ArrayList<Column> columns = new ArrayList<Column>();
        Schema dssSchema = resultSet.getSchema();
        for (SchemaColumn cs2 : dssSchema.getColumns()) {
            columns.add(cf.column(cs2.getName()));
        }
        logger.info((Object)"Query done, streaming results");
        resp.setStatus(200);
        resp.setContentType("text/csv");
        formatter.header((ColumnFactory)cf, (OutputStream)bos);
        formatter.setOutputSchema(dssSchema);
        Map<Object, Object> testProps = resultSet instanceof StreamedJdbcResultSet ? ((StreamedJdbcResultSet)resultSet).testProps : new HashMap();
        Long failAfterNRows = testProps.getOrDefault("fail_after_n_rows", null);
        long nextTouch = 0L;
        long count = 0L;
        while (resultSet.next()) {
            if (failAfterNRows != null && count >= failAfterNRows) {
                throw new Exception("Designed to fail");
            }
            Row row = rf.row();
            resultSet.fillRow(row, columns, dssSchema.getColumns());
            formatter.format(row, (ColumnFactory)cf, (OutputStream)bos);
            ++count;
            long now = System.currentTimeMillis();
            if (nextTouch != 0L && now <= nextTouch) continue;
            nextTouch = now + 60000L;
            this.streamingSessions.getIfPresent((Object)queryId);
        }
        formatter.footer((ColumnFactory)cf, (OutputStream)bos);
        bos.flush();
        logger.info((Object)("Query reading done, sent " + count + " rows"));
    }

    private class SQLStreamingSessionCloser
    implements RemovalListener<String, SQLStreamingSession> {
        private SQLStreamingSessionCloser() {
        }

        public void onRemoval(RemovalNotification<String, SQLStreamingSession> removed) {
            block3: {
                String key = (String)removed.getKey();
                SQLStreamingSession streamingSession = (SQLStreamingSession)removed.getValue();
                if (key != null && streamingSession != null && !streamingSession.finished) {
                    logger.error((Object)("Close the SQL streaming session " + key));
                    try {
                        streamingSession.query.releaseResources();
                        streamingSession.finished = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Closing the SQL streaming session " + key + " failed."), (Throwable)e);
                        if (SQLQueryStreamService.this.queryFailures.getIfPresent((Object)key) != null) break block3;
                        SQLQueryStreamService.this.queryFailures.put((Object)key, (Object)e);
                    }
                }
            }
        }
    }

    public static class SQLStreamingSessionInfo {
        public String queryId;
        public boolean hasResults;
        public List<SchemaColumn> schema;

        public SQLStreamingSessionInfo(String queryId, boolean hasResults, List<SchemaColumn> schema) {
            this.queryId = queryId;
            this.hasResults = hasResults;
            this.schema = schema;
        }
    }

    private class StreamingJdbcQuery
    implements StreamingQuery {
        private final SQLConnectionProvider.SQLConnectionData connectionData;
        private final String[] postStatements;
        private final String[] preStatements;
        private final String query;
        private final List<ScriptStep> scriptSteps;
        private Schema scriptInputSchema;
        private final Schema scriptOutputSchema;
        private final String scriptReportLocation;
        private final AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode;
        private final AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode;
        private Statement statement;
        private SQLConnectionProvider.SQLConnectionWrapper connection;
        private boolean runPostQueries;
        private StreamedJdbcResultSet resultSet;
        private AuthCtx authCtx;
        private final String projectKey;

        public StreamingJdbcQuery(SQLConnectionProvider.SQLConnectionData connectionData, String[] preStatements, String query, String[] postStatements, List<ScriptStep> scriptSteps, Schema scriptInputSchema, Schema scriptOutputSchema, String scriptReportLocation, AuthCtx authCtx, String projectKey, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
            this.connectionData = connectionData;
            this.preStatements = preStatements;
            this.query = query;
            this.postStatements = postStatements;
            this.scriptSteps = scriptSteps;
            this.scriptInputSchema = scriptInputSchema;
            this.scriptOutputSchema = scriptOutputSchema;
            this.scriptReportLocation = scriptReportLocation;
            this.authCtx = authCtx;
            this.projectKey = projectKey;
            this.dateonlyReadMode = dateonlyReadMode;
            this.datetimenotzReadMode = datetimenotzReadMode;
        }

        @Override
        public void takeResources(String projectKey) throws Exception {
            this.runPostQueries = false;
            this.connection = SQLConnectionProvider.newConnection(this.connectionData, this.authCtx, projectKey);
            try {
                Object currentOperation = "statement creation";
                this.statement = SQLUtils.getProperlyStreamableStatement(this.connectionData, this.connection);
                try {
                    for (String preQuery : this.preStatements) {
                        logger.info((Object)("Executing pre-query: " + preQuery));
                        currentOperation = "pre-query '" + preQuery + "'";
                        try (Statement preStatement = SQLUtils.getProperlyStreamableStatement(this.connectionData, this.connection);){
                            SQLUtils.execute(this.connection, preStatement, preQuery, true);
                        }
                    }
                    if (this.scriptSteps != null && !this.scriptSteps.isEmpty()) {
                        logger.info((Object)("Apply script steps to query or dataframe in dialect " + this.connectionData.getDialect().getClass().getCanonicalName()));
                        if (this.scriptInputSchema == null) {
                            if (this.connectionData.getDialect().supportsResultSetMetadataOnPreparedStatement(this.query)) {
                                try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.query);){
                                    this.scriptInputSchema = SchemaReader.metadataToSchema(this.connectionData.getDialect(), preparedStatement.getMetaData(), this.datetimenotzReadMode, this.dateonlyReadMode);
                                }
                                catch (Throwable e) {
                                    logger.warn((Object)"Unable to prepare the query in order to get the schema");
                                    this.getQuerySchemaWithoutPrepare();
                                }
                            } else {
                                this.getQuerySchemaWithoutPrepare();
                            }
                            this.connectionData.getDialect().setDefaultLengthForSchemaColumn(this.scriptInputSchema, Collections.emptyList(), new InfoMessage.InfoMessages());
                        }
                        if (this.connection.getConnectionUnsafe(true) instanceof DkuSparkSQLConnection) {
                            DkuSparkSQLConnection sparkSQLConnection = (DkuSparkSQLConnection)this.connection.getConnectionUnsafe(true);
                            this.statement.close();
                            this.statement = sparkSQLConnection.executeQueryAndScript(this.query, this.scriptSteps, this.scriptOutputSchema, this.scriptReportLocation);
                        } else {
                            SQLUtils.SQLTable withTable = new SQLUtils.SQLTable(null, null, "__temp_query__", false);
                            List<ProcessorScriptStep> processorScriptSteps = AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(this.scriptSteps);
                            SQLQueryWithSchema translatedSqb = this.scriptOutputSchema != null ? new ShakerSQLTranslator().translateAndCast((AuthCtx)this.authCtx, (String)projectKey, processorScriptSteps, (Schema)this.scriptInputSchema, (SQLUtils.SQLTable)withTable, (AbstractSQLConnection)this.connectionData.getConnection(), (Dataset)new Dataset().withSchema((Schema)this.scriptOutputSchema), null, null, null, null, null, (boolean)false, (ShakerSQLTranslator.ShakerSQLTranslatorContext)ShakerSQLTranslator.ShakerSQLTranslatorContext.STREAMING_WITH_STEPS).translated : new ShakerSQLTranslator().translate((AuthCtx)this.authCtx, (String)projectKey, processorScriptSteps, (Schema)this.scriptInputSchema, (SQLUtils.SQLTable)withTable, (AbstractSQLConnection)this.connectionData.getConnection(), null, null, null, (boolean)false, (ShakerSQLTranslator.ShakerSQLTranslatorContext)ShakerSQLTranslator.ShakerSQLTranslatorContext.STREAMING_WITH_STEPS).translated;
                            translatedSqb.withInlineQuery(this.query, "__temp_query__");
                            String translatedScript = translatedSqb.toSQL(this.connectionData.getDialect());
                            logger.info((Object)("Executing SQL query in " + String.valueOf(this.connection) + ": " + translatedScript));
                            currentOperation = "query '" + translatedScript + "'";
                            SQLUtils.execute(this.connection, this.statement, translatedScript, true);
                        }
                    } else {
                        logger.info((Object)("Executing SQL query in " + String.valueOf(this.connection) + ": " + this.query));
                        currentOperation = "query '" + this.query + "'";
                        SQLUtils.execute(this.connection, this.statement, this.query, true);
                    }
                    ResultSet jdbcResultSet = this.statement.getResultSet();
                    if (jdbcResultSet != null) {
                        HashMap<String, Object> testProps = new HashMap<String, Object>();
                        Matcher matcher = LONG_TYPED_HINTS.matcher(this.query);
                        while (matcher.find()) {
                            testProps.put(matcher.group(1), Long.parseLong(matcher.group(2)));
                        }
                        this.resultSet = new StreamedJdbcResultSet(jdbcResultSet, this.connectionData, this.datetimenotzReadMode, this.dateonlyReadMode, testProps);
                    } else {
                        this.resultSet = null;
                    }
                    this.runPostQueries = true;
                }
                catch (Exception ex) {
                    this.statement.close();
                    throw new Exception("During " + (String)currentOperation + ": " + ex.getMessage(), ex);
                }
            }
            catch (Exception ex) {
                try {
                    this.connection.close();
                }
                catch (Exception ex2) {
                    logger.error((Object)"Failed to close connection", (Throwable)ex2);
                }
                throw ex;
            }
        }

        private void getQuerySchemaWithoutPrepare() throws SQLException {
            String limitedQuery = this.connectionData.getDialect().getLimitedQuery(this.query, 0L);
            try (Statement regularStatement = this.connection.createStatement();
                 ResultSet schemaResultSet = regularStatement.executeQuery(limitedQuery);){
                this.scriptInputSchema = SchemaReader.metadataToSchema(this.connectionData.getDialect(), schemaResultSet.getMetaData(), this.datetimenotzReadMode, this.dateonlyReadMode);
            }
            catch (Throwable e) {
                logger.warn((Object)"Unable to limit 0 the query in order to get the schema");
                try (Statement regularStatement2 = this.connection.createStatement();
                     ResultSet schemaResultSet2 = regularStatement2.executeQuery(this.query);){
                    this.scriptInputSchema = SchemaReader.metadataToSchema(this.connectionData.getDialect(), schemaResultSet2.getMetaData(), this.datetimenotzReadMode, this.dateonlyReadMode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseResources() throws Exception {
            try {
                try {
                    if (this.runPostQueries) {
                        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forSqlStreaming((AuthCtx)this.authCtx, (String)this.projectKey);
                        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
                        for (String postQuery : this.postStatements) {
                            logger.info((Object)("Executing post-query: " + postQuery));
                            try (Statement postStatement = SQLUtils.getProperlyStreamableStatement(this.connectionData, this.connection);){
                                SQLUtils.execute(this.connection, postStatement, postQuery, true);
                            }
                        }
                    }
                }
                finally {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        @Override
        public StreamedResultSet getResultSet() {
            return this.resultSet;
        }
    }

    private static interface StreamingQuery {
        public void takeResources(String var1) throws Exception;

        public StreamedResultSet getResultSet();

        public void releaseResources() throws Exception;
    }

    private class SQLStreamingSession {
        List<SchemaColumn> schema;
        StreamingQuery query;
        DSSConnection connInfo;
        boolean finished;

        public SQLStreamingSession(StreamingQuery query) throws SQLException {
            this.query = query;
            this.schema = query.getResultSet() != null ? query.getResultSet().getSchema().getColumns() : null;
            this.finished = false;
        }
    }

    private static interface StreamedResultSet {
        public Schema getSchema() throws SQLException;

        public boolean next() throws SQLException;

        public void fillRow(Row var1, List<Column> var2, List<SchemaColumn> var3) throws SQLException;
    }

    private class StreamedJdbcResultSet
    implements StreamedResultSet {
        private final ResultSet resultSet;
        private final SQLConnectionProvider.SQLConnectionData connectionData;
        private final ResultSetMetaData resultSetMetadata;
        private final SQLDialect dialect;
        private final AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode;
        private final AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode;
        private final Map<String, Object> testProps;
        private int[] columnTypes;

        public StreamedJdbcResultSet(ResultSet resultSet, SQLConnectionProvider.SQLConnectionData connectionData, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Map<String, Object> testProps) throws SQLException {
            this.resultSet = resultSet;
            this.connectionData = connectionData;
            this.datetimenotzReadMode = datetimenotzReadMode;
            this.dateonlyReadMode = dateonlyReadMode;
            this.resultSetMetadata = resultSet.getMetaData();
            this.dialect = connectionData.getDialect();
            this.testProps = testProps;
        }

        @Override
        public Schema getSchema() throws SQLException {
            Schema schema = SchemaReader.metadataToSchema(this.connectionData.getDialect(), this.resultSetMetadata, this.datetimenotzReadMode, this.dateonlyReadMode);
            this.columnTypes = new int[schema.getColumns().size()];
            for (int i = 1; i <= schema.getColumns().size(); ++i) {
                this.columnTypes[i - 1] = this.resultSetMetadata.getColumnType(i);
            }
            return schema;
        }

        @Override
        public boolean next() throws SQLException {
            return this.resultSet.next();
        }

        @Override
        public void fillRow(Row row, List<Column> columns, List<SchemaColumn> schemaColumns) throws SQLException {
            for (int i = 1; i <= columns.size(); ++i) {
                SchemaColumn schemaColumn = schemaColumns.get(i - 1);
                String val = this.dialect.getValueAsDSSString(this.resultSet, this.columnTypes[i - 1], i, schemaColumn, true, false, DateTimeZone.UTC);
                row.put(columns.get(i - 1), val);
            }
        }
    }

    public static class SQLQueryRequest {
        public String connection;
        public String database;
        public String datasetFullName;
        public String query;
        public String projectKey;
        public List<String> preQueries = new ArrayList<String>();
        public List<String> postQueries = new ArrayList<String>();
        public Map<String, String> extraConf = new HashMap<String, String>();
        public String type = "sql";
        public List<ScriptStep> scriptSteps;
        public Schema scriptInputSchema;
        public Schema scriptOutputSchema;
        public String scriptReportLocation;
        public AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
        public AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
        public Boolean readTimestampWithoutTimezoneAsString;
        public Boolean readDateAsString;
    }
}

