/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.shaker.filter.Faceter;
import com.dataiku.dip.shaker.filter.FilterRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class AlphanumFaceter
extends Faceter {
    private Sort sort;
    private int maxResults;
    FilterFacet ret = new FilterFacet();

    public AlphanumFaceter(String column, Sort sort, int maxResults) {
        this.column = column;
        this.sort = sort;
        this.maxResults = maxResults;
    }

    @Override
    protected void observe(MemTable table, Column cd, boolean[] filters) {
        CountMap<String> counts = new CountMap<String>();
        for (int i = 0; i < table.rows.size(); ++i) {
            if (!filters[i]) continue;
            MemRow row = table.rows.get(i);
            String v = row.get(cd);
            if (v == null || v.isEmpty()) {
                v = "___dku_no_value___";
            }
            counts.inc(v);
        }
        ArrayList<FilterFacet.Val> values = new ArrayList<FilterFacet.Val>();
        for (Map.Entry e : counts) {
            values.add(new FilterFacet.Val((String)e.getKey(), (String)e.getKey(), (long)e.getValue().intValue()));
        }
        Collections.sort(values, this.sort);
        if (this.maxResults > 0) {
            while (values.size() > this.maxResults) {
                values.remove(values.size() - 1);
            }
        }
        this.ret.values = values;
        this.ret.count = counts.size();
    }

    @Override
    public FilterFacet compute() {
        this.ret.column = this.column;
        this.ret.type = FilterRequest.FilterType.ALPHANUM_FACET;
        return this.ret;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Sort implements Comparator<FilterFacet.Val>
    {
        ALPHANUM{

            @Override
            public int compare(FilterFacet.Val o1, FilterFacet.Val o2) {
                String lowerO2;
                String lowerO1 = o1.label.toLowerCase();
                int cmp = lowerO1.compareTo(lowerO2 = o2.label.toLowerCase());
                if (cmp == 0) {
                    return o1.label.compareTo(o2.label);
                }
                return cmp;
            }
        }
        ,
        COUNT{

            @Override
            public int compare(FilterFacet.Val o1, FilterFacet.Val o2) {
                if (o1.count == o2.count) {
                    return ALPHANUM.compare(o1, o2);
                }
                return -Long.compare(o1.count, o2.count);
            }
        };

    }

    static class FacetValue {
        String key;
        int value;

        FacetValue() {
        }
    }
}

