/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.model;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.datasets.LatestPartitionsSelector;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.signature.DatasetSignatures;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class ShakerSamplingUtils {
    private static final Pattern SIGNATURE_PARTS_PATTERN = Pattern.compile("^(\\w{32})-(\\w{32}|NA)-(\\w{32})(\\d+)--(\\w{32})(?:-(\\w{32}))?$");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.sample");

    public static String computeSampleId(AuthCtx authCtx, Dataset dataset, SerializedShakerScript.ShakerExplorationSampleSettings sampling) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return ShakerSamplingUtils.computeSampleId(authCtx, dataset, sampling, Collections.emptyList());
    }

    public static String computeSampleId(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, SerializedShakerScript.ShakerExplorationSampleSettings sampling) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return ShakerSamplingUtils.computeSampleId(authCtx, streamingEndpoint, sampling, Collections.emptyList());
    }

    private static String computeSampleId(AuthCtx authCtx, Dataset dataset, SerializedShakerScript.ShakerExplorationSampleSettings sampling, List<ScriptStep> steps) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        String basicSignature = null;
        String contentSignature = null;
        DatasetSelection selection = ShakerSamplingUtils.normalizeSelection(sampling.selection);
        if (dataset.getPartitioningSchema() == null || !dataset.getPartitioningSchema().isPartitioned() || selection.partitionSelectionMethod == DatasetSelection.PartitionSelectionMethod.ALL) {
            basicSignature = DatasetSignatures.computeBasicSignature(dataset, null);
            if (sampling.autoRefreshSample) {
                contentSignature = DatasetSignatures.computeContentSignature(authCtx, dataset);
            }
        } else {
            basicSignature = DatasetSignatures.computeBasicSignature(dataset, selection.selectedPartitions);
            if (sampling.autoRefreshSample) {
                contentSignature = DatasetSignatures.computeContentSignature(authCtx, dataset, selection.selectedPartitions);
            }
        }
        String samplingSignature = DigestUtils.md5Hex((String)JSON.json((Object)((Object)selection))) + sampling._refreshTrigger;
        String stepsSignature = DigestUtils.md5Hex((String)JSON.json(steps));
        return basicSignature + "-" + (contentSignature == null ? "NA" : contentSignature) + "-" + samplingSignature + "--" + stepsSignature;
    }

    private static String computeSampleId(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, SerializedShakerScript.ShakerExplorationSampleSettings sampling, List<ScriptStep> steps) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        String basicSignature = null;
        String contentSignature = null;
        DatasetSelectionToMemTable selection = sampling.selection;
        basicSignature = DatasetSignatures.computeBasicSignature(streamingEndpoint, null);
        if (sampling.autoRefreshSample) {
            contentSignature = DatasetSignatures.computeContentSignature(authCtx, streamingEndpoint);
        }
        String samplingSignature = DigestUtils.md5Hex((String)JSON.json((Object)((Object)selection))) + sampling._refreshTrigger;
        String stepsSignature = DigestUtils.md5Hex((String)JSON.json(steps));
        return basicSignature + "-" + (contentSignature == null ? "NA" : contentSignature) + "-" + samplingSignature + "--" + stepsSignature;
    }

    public static String computeSampleId(AuthCtx authCtx, Dataset dataset, SerializedShakerScript.RefreshableStreamableSelection sampling, List<ScriptStep> steps, MemTable mt) throws Exception {
        Object basicSignature = null;
        String contentSignature = null;
        StreamableDatasetSelection selection = sampling.selection;
        if (dataset.getPartitioningSchema() == null || !dataset.getPartitioningSchema().isPartitioned()) {
            basicSignature = DatasetSignatures.computeBasicSignature(dataset, null);
            if (sampling.autoRefreshSample) {
                contentSignature = DatasetSignatures.computeContentSignature(authCtx, dataset);
            }
        } else {
            switch (selection.partitionSelectionMethod) {
                case ALL: {
                    basicSignature = DatasetSignatures.computeBasicSignature(dataset, null);
                    if (!sampling.autoRefreshSample) break;
                    contentSignature = DatasetSignatures.computeContentSignature(authCtx, dataset);
                    break;
                }
                case SELECTED: {
                    basicSignature = DatasetSignatures.computeBasicSignature(dataset, selection.selectedPartitions);
                    if (!sampling.autoRefreshSample) break;
                    contentSignature = DatasetSignatures.computeContentSignature(authCtx, dataset, selection.selectedPartitions);
                    break;
                }
                case LATEST_N: {
                    basicSignature = DatasetSignatures.computeBasicSignature(dataset, null);
                    basicSignature = (String)basicSignature + "-plast" + selection.latestPartitionsN;
                    if (!sampling.autoRefreshSample) break;
                    List<Partition> partitions = LatestPartitionsSelector.select(authCtx, dataset, selection.latestPartitionsN);
                    contentSignature = DatasetSignatures.computeContentSignature(authCtx, dataset, PartitioningUtils.toIds(partitions));
                }
            }
        }
        Object meanings = "";
        for (MemColumn c2 : mt.columns.values()) {
            meanings = (String)meanings + c2.getName() + "=" + (c2.selectedType == null ? "??" : c2.selectedType.type.getMeaningId());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Compute sample id: " + JSON.json((Object)((Object)selection)) + " refresh=" + sampling._refreshTrigger + " m=" + (String)meanings));
        }
        DatasetSelection cleanSelection = (DatasetSelection)((Object)JSON.deepCopy((Object)((Object)selection)));
        if (cleanSelection.samplingMethod != null) {
            switch (cleanSelection.samplingMethod) {
                case CLASS_REBALANCE_TARGET_NB_APPROX: {
                    cleanSelection.targetRatio = 0.0;
                    break;
                }
                case CLASS_REBALANCE_TARGET_RATIO_APPROX: {
                    cleanSelection.maxRecords = 0L;
                    break;
                }
                case COLUMN_BASED: {
                    cleanSelection.targetRatio = 0.0;
                    break;
                }
                case FULL: {
                    cleanSelection.maxRecords = 0L;
                    cleanSelection.column = null;
                    cleanSelection.targetRatio = 0.0;
                    break;
                }
                case HEAD_SEQUENTIAL: {
                    cleanSelection.column = null;
                    cleanSelection.targetRatio = 0.0;
                    break;
                }
                case RANDOM_FIXED_NB: 
                case RANDOM_FIXED_NB_EXACT: {
                    cleanSelection.column = null;
                    cleanSelection.targetRatio = 0.0;
                    break;
                }
                case RANDOM_FIXED_RATIO: 
                case RANDOM_FIXED_RATIO_EXACT: {
                    cleanSelection.column = null;
                    cleanSelection.maxRecords = 0L;
                    break;
                }
                case STRATIFIED_TARGET_NB_EXACT: {
                    cleanSelection.targetRatio = 0.0;
                    break;
                }
                case STRATIFIED_TARGET_RATIO_EXACT: {
                    cleanSelection.maxRecords = 0L;
                    break;
                }
                case TAIL_SEQUENTIAL: {
                    cleanSelection.column = null;
                    cleanSelection.targetRatio = 0.0;
                }
            }
        }
        if (cleanSelection.filter != null && !cleanSelection.filter.enabled) {
            cleanSelection.filter.uiData = null;
        }
        String samplingSignature = DigestUtils.md5Hex((String)JSON.json((Object)((Object)cleanSelection)));
        String stepsSignature = DigestUtils.md5Hex((String)JSON.json(steps));
        String meaningsSignature = DigestUtils.md5Hex((String)meanings);
        return (String)basicSignature + "-" + (contentSignature == null ? "NA" : contentSignature) + "-" + samplingSignature + "--" + stepsSignature + "-" + meaningsSignature;
    }

    public static SampleIdDecomposition decomposeSampleId(String sampleId) {
        Matcher signaturePartsMatcher = SIGNATURE_PARTS_PATTERN.matcher(sampleId);
        if (!signaturePartsMatcher.find() || signaturePartsMatcher.groupCount() != 5 && signaturePartsMatcher.groupCount() != 6) {
            return null;
        }
        return new SampleIdDecomposition(signaturePartsMatcher.group(1), signaturePartsMatcher.group(2), signaturePartsMatcher.group(3), signaturePartsMatcher.group(4), signaturePartsMatcher.group(5), signaturePartsMatcher.groupCount() == 6 ? signaturePartsMatcher.group(6) : null);
    }

    @VisibleForTesting
    static DatasetSelection normalizeSelection(DatasetSelection selection) {
        boolean isNormalizedPartitioning;
        boolean isNormalizedFiltering = FilterDescUtils.isNormalized(selection.filter);
        boolean isNormalizedOrdering = selection.ordering == null || selection.ordering.isNormalized();
        boolean bl = isNormalizedPartitioning = selection.partitionSelectionMethod != DatasetSelection.PartitionSelectionMethod.ALL || selection.selectedPartitions == null;
        if (!(isNormalizedFiltering && isNormalizedOrdering && isNormalizedPartitioning)) {
            DatasetSelection selectionCopy = (DatasetSelection)((Object)JSON.deepCopy((Object)((Object)selection)));
            FilterDescUtils.normalize(selectionCopy.filter);
            if (selectionCopy.ordering != null) {
                selectionCopy.ordering.normalize();
            }
            if (!isNormalizedPartitioning) {
                selectionCopy.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
                selectionCopy.selectedPartitions = null;
            }
            return selectionCopy;
        }
        return selection;
    }

    public static class SampleIdDecomposition {
        public final String basicSignature;
        public final String contentSignature;
        public final String selectionSignature;
        public final String refreshTrigger;
        public final String stepsSignature;
        public final String meaningsSignature;

        public SampleIdDecomposition(String basicSignature, String contentSignature, String selectionSignature, String refreshTrigger, String stepsSignature, String meaningsSignature) {
            this.basicSignature = basicSignature;
            this.contentSignature = contentSignature;
            this.selectionSignature = selectionSignature;
            this.refreshTrigger = refreshTrigger;
            this.stepsSignature = stepsSignature;
            this.meaningsSignature = meaningsSignature;
        }
    }
}

