/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.avro.AvroReusableRow;
import com.dataiku.dip.formats.avro.AvroReusableRowWriter;
import com.dataiku.dip.formats.avro.AvroRowConverter;
import com.dataiku.dip.formats.avro.SchemaConverter;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class AvroOutputFormatAdapter
extends FileOutputFormat<Void, RowWithFactories> {
    private static final DKULogger logger = DKULogger.getLogger(AvroOutputFormatAdapter.class);
    private final AvroFormatConfig formatParams;
    private final com.dataiku.dip.coremodel.Schema outputSchema;
    private final WarningsContext warningsContext;

    public AvroOutputFormatAdapter(DatasetConfig inputConf, WarningsContext warningsContext) {
        this.formatParams = (AvroFormatConfig)inputConf.dataset.getFormatParams();
        this.outputSchema = inputConf.dataset.getSchema();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public RecordWriter<Void, RowWithFactories> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new InternalRecordWriter(taskAttemptContext);
    }

    private class InternalRecordWriter
    extends RecordWriter<Void, RowWithFactories> {
        private final TaskAttemptContext taskAttemptContext;
        private AvroReusableRow reusableRow = new AvroReusableRow();
        private boolean initialized;
        private AvroRowConverter rowConverter;
        private DataFileWriter<AvroReusableRow> fileWriter;

        public InternalRecordWriter(TaskAttemptContext taskAttemptContext) {
            this.taskAttemptContext = taskAttemptContext;
        }

        private void lazyInit(RowWithFactories mrRow) throws IOException {
            if (!this.initialized) {
                this.initialized = true;
                Schema avroSchema = SchemaConverter.convertSchema(AvroOutputFormatAdapter.this.outputSchema, SchemaConverter.AvroFlavor.HIVE);
                Object scf = mrRow != null && mrRow.getColumnFactory() != null ? mrRow.getColumnFactory() : new StreamColumnFactory();
                this.rowConverter = new AvroRowConverter((ColumnFactory)scf, AvroOutputFormatAdapter.this.outputSchema, avroSchema);
                this.fileWriter = new DataFileWriter((DatumWriter)new AvroReusableRowWriter());
                String compressionExtension = "";
                switch (AvroOutputFormatAdapter.this.formatParams.avroCompressionMethod) {
                    case DEFLATE_1: {
                        this.fileWriter.setCodec(CodecFactory.deflateCodec((int)1));
                        compressionExtension = ".deflate";
                        break;
                    }
                    case DEFLATE_5: {
                        this.fileWriter.setCodec(CodecFactory.deflateCodec((int)5));
                        compressionExtension = ".deflate";
                        break;
                    }
                    case DEFLATE_9: {
                        this.fileWriter.setCodec(CodecFactory.deflateCodec((int)9));
                        compressionExtension = ".deflate";
                        break;
                    }
                    case SNAPPY: {
                        this.fileWriter.setCodec(CodecFactory.snappyCodec());
                        compressionExtension = ".snappy";
                        break;
                    }
                    default: {
                        this.fileWriter.setCodec(CodecFactory.nullCodec());
                    }
                }
                Path workFile = AvroOutputFormatAdapter.this.getDefaultWorkFile(this.taskAttemptContext, compressionExtension + ".avro");
                logger.info((Object)("Work file : " + String.valueOf(workFile)));
                FSDataOutputStream dataOutputStream = workFile.getFileSystem(this.taskAttemptContext.getConfiguration()).create(workFile);
                this.fileWriter.create(avroSchema, (OutputStream)dataOutputStream);
            }
        }

        public void write(Void aVoid, RowWithFactories mrRow) throws IOException, InterruptedException {
            this.lazyInit(mrRow);
            this.reusableRow.clear();
            boolean ok = false;
            try {
                this.rowConverter.write(mrRow.getRow(), this.reusableRow);
                ok = true;
            }
            catch (IOException e) {
                AvroOutputFormatAdapter.this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Unable to write row. " + e.getMessage(), (Throwable)e, logger);
            }
            if (ok) {
                this.fileWriter.append((Object)this.reusableRow);
            }
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.lazyInit(null);
            this.fileWriter.close();
        }
    }
}

