/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.reshaping.UnfoldProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Unfold
extends UnfoldProcessor
implements Processor,
ProcessorWithRecordedReport {
    public static final ProcessorMeta<Unfold, Parameter> META = new ProcessorMeta<Unfold, Parameter>(){

        @Override
        public String getName() {
            return "Unfold";
        }

        @Override
        public String getDocPage() {
            return "unfold";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.Unfold.HELP", "This processor transforms the values of a column into several binary columns. Also called 'dummification'.\n\nYou can prefix new columns by filling the \"Prefix\" option.\n\nYou can choose the maximum number of columns to create with the \"Max nb. columns to create\" option.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return UnfoldProcessor.addColumnLimitationsDesc(language, new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.Unfold.DESCRIPTION", 1.actionVerb("Unfold")), false).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withParam("prefix", "String", false, true, this.translate(language, "SHAKER.PROCESSOR.Unfold.DESCRIPTION.PREFIX", "Prefix (empty for no prefix)")));
        }

        @Override
        public Unfold build(Parameter parameter) {
            return new Unfold(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (report != null && report.report.has("unfoldedValues")) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
            } else {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: no unfoldedValues were recorded");
                ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: no unfoldedValues were recorded");
            }
            return ret;
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) throws IOException {
            List unfoldedValues = (List)JSON.parse((JsonElement)report.report.get("unfoldedValues"), (TypeToken)new TypeToken<List<String>>(){});
            return new SQLTranslator((Parameter)parameter, unfoldedValues);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.reshaping.UnfoldNS";
        }
    };
    private final Parameter parameter;
    private Column unfoldCD;
    private String nextColName;
    private List<String> actuallyCreatedColumns = new ArrayList<String>();
    private Set<String> actuallyCreatedColumnsSet = new HashSet<String>();

    public Unfold(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.unfoldCD = this.getColumnFactory().column(this.parameter.column, Processor.ProcessorRole.INPUT_COLUMN);
        Column nextColCD = this.getColumnFactory().getColumnAfter(this.parameter.column);
        this.nextColName = nextColCD == null ? null : nextColCD.getName();
    }

    public void processRow(Row row) throws Exception {
        String v = row.get(this.unfoldCD);
        if (v == null || v.isEmpty()) {
            return;
        }
        this.enrichCreatedColumns(v, (UnfoldProcessor.UnfoldParameter)this.parameter);
        if (this.parameter.overflowAction == UnfoldProcessor.OverflowAction.KEEP || this.createdColumns.contains(v)) {
            String columnName = this.parameter.prefix == null ? v : this.parameter.prefix + v;
            row.put(this.getColumnFactory().columnBefore(this.nextColName, columnName, Processor.ProcessorRole.OUTPUT_COLUMN), "1");
            if (this.actuallyCreatedColumnsSet.add(columnName)) {
                this.actuallyCreatedColumns.add(columnName);
            }
        }
    }

    public void postProcess() throws Exception {
    }

    @Override
    public ProcessorWithRecordedReport.ProcessorRecordedReport getRecordedReport() {
        ProcessorWithRecordedReport.ProcessorRecordedReport ret = new ProcessorWithRecordedReport.ProcessorRecordedReport();
        JsonArray arr = new JsonArray();
        for (String acc : this.actuallyCreatedColumns) {
            if (this.parameter.prefix != null) {
                acc = acc.substring(this.parameter.prefix.length());
            }
            arr.add((JsonElement)new JsonPrimitive(acc));
        }
        ret.report.add("unfoldedValues", (JsonElement)arr);
        return ret;
    }

    public static class Parameter
    extends UnfoldProcessor.UnfoldParameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String column;
        String prefix;

        public void validate() {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;
        private final List<String> unfoldedValues;

        private SQLTranslator(Parameter parameter, List<String> unfoldedValues) {
            this.parameter = parameter;
            this.unfoldedValues = unfoldedValues;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            ArrayList affectedColumns = Lists.newArrayList((Object[])new String[]{this.parameter.column});
            if (chain.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns)) {
                chain = chain.makeSubquery();
            }
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            SchemaColumn schemaColumn = (SchemaColumn)chain.getInputColumn(this.parameter.column).get();
            for (String unfoldedValue : this.unfoldedValues) {
                String unfoldedColumn = StringUtils.defaultIfBlank((String)this.parameter.prefix, (String)"") + unfoldedValue;
                chain.addColumnAfter(this.parameter.column, new SchemaColumn(unfoldedColumn, Type.BIGINT));
                chain.select(ebf.caseWhen(chain.col(this.parameter.column).eq(ebf.cst(unfoldedValue).cast(schemaColumn.getType(), schemaColumn.getMaxLength())), ebf.cst(1)).cast(Type.BIGINT), unfoldedColumn);
            }
            return chain;
        }
    }
}

