/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform.interactivedatapreparation;

import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.ExtractingPattern;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.InteractiveExtractor;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.TokenPattern;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.Anything;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.ExactMatching;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.QuantifiedToken;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.SimpleToken;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.Token;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.TokenBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TokenizedSelection {
    static TokenBuilder builder = new TokenBuilder();
    InteractiveExtractor.Selection rawSelection;
    List<Word> before;
    List<Word> selection;
    List<Word> after;
    static final int SELECTION_MAX_SIZE = 8;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.idp");

    TokenizedSelection(InteractiveExtractor.Selection sel) {
        this.rawSelection = sel;
        this.before = TokenizedSelection.stringToWords(sel.before, false);
        this.selection = TokenizedSelection.stringToWords(sel.selection, true);
        this.after = TokenizedSelection.stringToWords(sel.after, false);
        Word startOfSentence = new Word("", Collections.singletonList(new SimpleToken("^", 1)));
        Word endOfSentence = new Word("", Collections.singletonList(new SimpleToken("$", 1)));
        this.before.add(0, startOfSentence);
        this.after.add(endOfSentence);
    }

    public List<ExtractingPattern> generateLooseSelectionExtractingPatterns(int complexity) {
        ArrayList<ExtractingPattern> extractingPatterns = new ArrayList<ExtractingPattern>();
        ArrayList<TokenPattern> selectionPatterns = new ArrayList<TokenPattern>();
        int selectionComplexityMax = this.selection.size() * 4;
        selectionPatterns.add(new TokenPattern(new Anything(true)));
        selectionPatterns.add(new TokenPattern(new Anything(false)));
        for (int selectionComplexity = 0; selectionComplexity <= selectionComplexityMax; ++selectionComplexity) {
            selectionPatterns.addAll(TokenizedSelection.generateTokenPatterns(selectionComplexity, this.selection, true, true));
        }
        for (int beforeComplexity = 0; beforeComplexity <= complexity; ++beforeComplexity) {
            int afterComplexity = 0;
            while (afterComplexity + beforeComplexity <= complexity) {
                ArrayList<TokenPattern> beforePatterns = new ArrayList<TokenPattern>(TokenizedSelection.generateTokenPatterns(beforeComplexity, this.before, true, false));
                ArrayList<TokenPattern> afterPatterns = new ArrayList<TokenPattern>(TokenizedSelection.generateTokenPatterns(afterComplexity, this.after, false, false));
                if (beforePatterns.size() == 0) {
                    beforePatterns.add(new TokenPattern(new SimpleToken("", 0)));
                }
                if (afterPatterns.size() == 0) {
                    afterPatterns.add(new TokenPattern(new SimpleToken("", 0)));
                }
                for (TokenPattern beforePattern : beforePatterns) {
                    for (TokenPattern selectionPattern : selectionPatterns) {
                        for (TokenPattern afterPattern : afterPatterns) {
                            ExtractingPattern newPattern = new ExtractingPattern(beforePattern, selectionPattern, afterPattern);
                            if (newPattern.score != complexity) continue;
                            extractingPatterns.add(newPattern);
                        }
                    }
                }
                ++afterComplexity;
            }
        }
        return extractingPatterns;
    }

    public List<ExtractingPattern> generatePreciseSelectionExtractingPatterns(int complexity) {
        ArrayList<TokenPattern> selectionPatterns = new ArrayList<TokenPattern>();
        ArrayList<ExtractingPattern> extractingPatterns = new ArrayList<ExtractingPattern>();
        List<QuantifiedToken> preciseTokenSelection = builder.buildPrecise(this.rawSelection.selection);
        TokenPattern preciseSelectionPattern = new TokenPattern(preciseTokenSelection);
        selectionPatterns.add(preciseSelectionPattern);
        for (int beforeComplexity = 0; beforeComplexity <= complexity - preciseSelectionPattern.getComplexity(); ++beforeComplexity) {
            int afterComplexity = 0;
            while (afterComplexity + beforeComplexity <= complexity - preciseSelectionPattern.getComplexity()) {
                List<TokenPattern> beforePatterns = TokenizedSelection.generateTokenPatterns(beforeComplexity, this.before, true, false);
                List<TokenPattern> afterPatterns = TokenizedSelection.generateTokenPatterns(afterComplexity, this.after, false, false);
                for (TokenPattern beforePattern : beforePatterns) {
                    for (TokenPattern selectionPattern : selectionPatterns) {
                        for (TokenPattern afterPattern : afterPatterns) {
                            ExtractingPattern newPattern = new ExtractingPattern(beforePattern, selectionPattern, afterPattern);
                            if (newPattern.score != complexity) continue;
                            extractingPatterns.add(newPattern);
                        }
                    }
                }
                ++afterComplexity;
            }
        }
        return extractingPatterns;
    }

    public static List<ExtractingPattern> generateUnionSelectionExtractingPattern(List<TokenizedSelection> TSelections) {
        ArrayList<String> sentences = new ArrayList<String>();
        for (TokenizedSelection tSelection : TSelections) {
            StringBuilder sentenceBld = new StringBuilder();
            for (Word word : tSelection.selection) {
                sentenceBld.append(word.value);
            }
            sentences.add(sentenceBld.toString());
        }
        ExactMatching unionToken = new ExactMatching(sentences);
        TokenPattern selectionUnionPattern = new TokenPattern(unionToken);
        TokenPattern beforePattern = new TokenPattern();
        TokenPattern afterPattern = new TokenPattern();
        return Collections.singletonList(new ExtractingPattern(beforePattern, selectionUnionPattern, afterPattern));
    }

    static List<Word> stringToWords(String sentence, boolean isSelection) {
        List<String> strWords = TokenizedSelection.split(sentence);
        ArrayList<Word> words = new ArrayList<Word>();
        if (isSelection && strWords.size() > 8) {
            logger.debug((Object)("too many words for selection : " + strWords.size()));
            String firstWord = strWords.get(0);
            String lastWord = strWords.get(strWords.size() - 1);
            words.add(new Word(firstWord, builder.build(firstWord)));
            words.add(new Word("", Collections.singletonList(new Anything(true))));
            words.add(new Word("", Collections.singletonList(new Anything(false))));
            words.add(new Word(lastWord, builder.build(lastWord)));
            return words;
        }
        for (String strWord : strWords) {
            words.add(new Word(strWord, builder.build(strWord)));
        }
        return words;
    }

    static List<String> split(String sentence) {
        String separators = " ,.;:'\"/-_<>!?@#$%^&*`~\u00a7[]{}()\\";
        char[] charSentence = sentence.toCharArray();
        ArrayList<String> splits = new ArrayList<String>();
        if (charSentence.length == 0) {
            return splits;
        }
        StringBuilder currentWord = new StringBuilder();
        for (char letter : charSentence) {
            if (" ,.;:'\"/-_<>!?@#$%^&*`~\u00a7[]{}()\\".contains(Character.toString(letter))) {
                if (currentWord.length() > 0) {
                    splits.add(currentWord.toString());
                }
                splits.add(Character.toString(letter));
                currentWord = new StringBuilder();
                continue;
            }
            currentWord.append(letter);
        }
        if (currentWord.length() > 0) {
            splits.add(currentWord.toString());
        }
        return splits;
    }

    static List<TokenPattern> generateTokenPatterns(int targetComplexity, List<Word> words, boolean toTheLeft, boolean useAllWords) {
        ArrayList<Word> wordsCopied = new ArrayList<Word>(words);
        if (toTheLeft) {
            Collections.reverse(wordsCopied);
        }
        List<TokenPattern> tokenPatterns = TokenizedSelection.generateTokenPatternsOfComplexity(targetComplexity, wordsCopied, useAllWords);
        if (toTheLeft) {
            ArrayList<TokenPattern> reorderedTokenPatterns = new ArrayList<TokenPattern>();
            for (TokenPattern tokenPattern : tokenPatterns) {
                ArrayList<? extends Token> reorderedTokens = new ArrayList<Token>(tokenPattern.tokens);
                Collections.reverse(reorderedTokens);
                reorderedTokenPatterns.add(new TokenPattern(reorderedTokens));
            }
            tokenPatterns = reorderedTokenPatterns;
        }
        return tokenPatterns;
    }

    static List<TokenPattern> generateTokenPatternsOfComplexity(int targetComplexity, List<Word> words, boolean useAllWords) {
        if (words.size() == 0) {
            return Collections.emptyList();
        }
        List<TokenPattern> candidates = new ArrayList<TokenPattern>();
        int numberOfTokens = -1;
        if (useAllWords) {
            numberOfTokens = words.size();
        }
        for (Token token : words.get((int)0).tokens) {
            candidates.add(new TokenPattern(Lists.newArrayList((Object[])new Token[]{token})));
        }
        ArrayList<TokenPattern> selected = new ArrayList<TokenPattern>(TokenizedSelection.selectCandidates(candidates, targetComplexity, numberOfTokens));
        candidates = TokenizedSelection.cleanCandidates(candidates, targetComplexity);
        for (Word word : words.subList(1, words.size())) {
            ArrayList<TokenPattern> newCandidates = new ArrayList<TokenPattern>();
            for (TokenPattern candidateTokenPattern : candidates) {
                for (Token token : word.tokens) {
                    newCandidates.add(candidateTokenPattern.join(token));
                }
            }
            selected.addAll(TokenizedSelection.selectCandidates(newCandidates, targetComplexity, numberOfTokens));
            candidates = TokenizedSelection.cleanCandidates(newCandidates, targetComplexity);
        }
        return selected;
    }

    static List<TokenPattern> cleanCandidates(List<TokenPattern> candidates, int targetComplexity) {
        ArrayList<TokenPattern> remainingCandidate = new ArrayList<TokenPattern>();
        for (TokenPattern candidate : candidates) {
            if (candidate.getComplexity() > targetComplexity || candidate.endsWithAnything()) continue;
            remainingCandidate.add(candidate);
        }
        return remainingCandidate;
    }

    static List<TokenPattern> selectCandidates(List<TokenPattern> candidates, int targetComplexity, int numberOfTokens) {
        ArrayList<TokenPattern> selectedCandidates = new ArrayList<TokenPattern>();
        for (TokenPattern candidate : candidates) {
            if (numberOfTokens > 0 && candidate.tokens.size() != numberOfTokens || candidate.endsWithAnything() || candidate.getComplexity() != targetComplexity) continue;
            selectedCandidates.add(candidate);
        }
        return selectedCandidates;
    }

    static class Word {
        String value;
        List<Token> tokens;

        Word(String strWord, List<Token> tokens) {
            this.value = strWord;
            this.tokens = tokens;
        }
    }
}

