/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.server.AdditionalInputAccessor;
import com.dataiku.dip.util.DatasetLocUtils;
import org.apache.log4j.Logger;

public class MemAdditionalInputAccessor
implements AdditionalInputAccessor {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final DatasetsDAO dao;
    MemTable table;
    private static Logger logger = Logger.getLogger((String)"dku.shaker.additional");

    public MemAdditionalInputAccessor(AuthCtx authCtx, DatasetsDAO dao, String projectKey) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.dao = dao;
    }

    @Override
    public MemAdditionalInput getAdditionalInput(String name) throws Exception {
        SerializedDataset sd = (SerializedDataset)this.dao.getMandatory(DatasetLocUtils.resolveSmart(this.projectKey, name));
        Dataset dataset = Dataset.fromSerialized(sd);
        MemAdditionalInput ret = new MemAdditionalInput();
        ret.table = new MemTable();
        logger.info((Object)"Ready to read additional input");
        UniversalSingleThreadPusher.push(this.authCtx, dataset, (ProcessorOutput)new MemTableAppendingOutput(ret.table), ret.table, ret.table);
        logger.info((Object)("Read additional " + ret.table.nrows() + " rows"));
        return ret;
    }

    public static class MemAdditionalInput
    implements AdditionalInputAccessor.AdditionalInput {
        MemTable table;

        @Override
        public ColumnFactory getColumnFactory() {
            return this.table;
        }

        @Override
        public RowInputStream getInput() throws Exception {
            return this.table.stream();
        }
    }
}

