/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.shaker.types.Text;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;

public class SerializedMemTableSimple {
    public List<SerializedMemTableV2.Header> headers = new ArrayList<SerializedMemTableV2.Header>();
    public List<Row> rows = new ArrayList<Row>();
    int totalRows;
    int totalKeptRows;
    int totalDeletedRows;
    int displayedRows;
    int totalEmptyCells;
    int totalFullCells;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.table");

    public void fromMemTable(MemTable mt, int firstRow, int nbRows) throws Exception {
        List<MemRow> keptRows = mt.rows;
        this.displayedRows = Math.min(nbRows + firstRow, keptRows.size()) - firstRow;
        this.totalRows = mt.rows.size();
        this.totalKeptRows = keptRows.size();
        logger.info((Object)("Display rows start=" + firstRow + " nb=" + nbRows + " totalKept=" + keptRows.size() + " columns=" + mt.ncols()));
        ArrayList<MemColumn> cdl = new ArrayList<MemColumn>();
        for (Column _cd : mt.columns()) {
            MemColumn cd = (MemColumn)_cd;
            SerializedMemTableV2.Header h = new SerializedMemTableV2.Header();
            h.name = cd.getName();
            if (cd.candidateTypes != null) {
                for (DataTypeMatch dtm : cd.candidateTypes) {
                    SerializedMemTableV2.MeaningResult dt = new SerializedMemTableV2.MeaningResult();
                    dt.name = dtm.type.getMeaningId();
                    dt.nbEmpty = dtm.nbEmpty;
                    dt.nbNOK = dtm.nbFails;
                    dt.nbOK = dtm.nbParses;
                    dt.score = dtm.totalDetectionScore;
                    h.possibleTypes.add(dt);
                }
            }
            if (cd.selectedType != null) {
                DataTypeMatch dtm = cd.selectedType;
                SerializedMemTableV2.MeaningResult dt = new SerializedMemTableV2.MeaningResult();
                dt.name = dtm.type.getMeaningId();
                dt.nbEmpty = dtm.nbEmpty;
                dt.nbNOK = dtm.nbFails;
                dt.nbOK = dtm.nbParses;
                dt.score = dtm.totalDetectionScore;
                if (dtm.type instanceof Text) {
                    h.deletedMeaningName = ((Text)dtm.type).deletedMeaningName;
                }
                h.selectedType = dt;
                h.meaningOrigin = cd.meaningOrigin;
                h.isDouble = cd.selectedType.type.isDouble();
                this.totalEmptyCells += dtm.nbEmpty;
                this.totalFullCells += dtm.nbParses + dtm.nbFails;
            }
            h.distinctValues = cd.distinctValues;
            this.headers.add(h);
            cdl.add(cd);
        }
        for (int rowIdx = firstRow; rowIdx < firstRow + this.displayedRows; ++rowIdx) {
            Row srow = new Row();
            MemRow mr = keptRows.get(rowIdx);
            srow.origRowIdx = mr.origRowIdx;
            for (MemColumn cd : cdl) {
                String val;
                Cell scell = new Cell();
                scell.value = val = mr.getFast(cd.index);
                if (mt.changeTracking) {
                    switch (mr.getCellState(cd)) {
                        case 0: {
                            scell.changeSt = "U";
                            break;
                        }
                        case 2: {
                            scell.changeSt = "C";
                            break;
                        }
                        case 1: {
                            scell.changeSt = "N";
                            break;
                        }
                        case 3: {
                            scell.changeSt = "D";
                            break;
                        }
                        default: {
                            throw new Error("Never reached");
                        }
                    }
                    scell.validSt = val == null ? "E" : (cd.selectedType != null && cd.selectedType.rowStatus[srow.origRowIdx] == 2 ? "F" : "O");
                } else {
                    scell.changeSt = "U";
                    scell.validSt = val == null ? "E" : (cd.selectedType != null && cd.selectedType.rowStatus[srow.origRowIdx] == 2 ? "F" : "O");
                }
                srow.cells.add(scell);
            }
            this.rows.add(srow);
        }
    }

    public static class Row {
        int origRowIdx;
        public List<Cell> cells = new ArrayList<Cell>();
    }

    public static class Cell {
        String validSt;
        String changeSt;
        public String value;
    }
}

