/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import java.io.IOException;
import java.sql.SQLException;

public class HiveSqlQueryWithSchemaBuilder
extends AbstractSqlQueryWithSchemaBuilder {
    public HiveSqlQueryWithSchemaBuilder(JobActivity activity) {
        super(activity);
    }

    @Override
    public SQLDialect computeDialect() {
        this.dialect = new HiveSQLDialect();
        return this.dialect;
    }

    @Override
    public AbstractSQLConnection getDSSConnection() throws IOException, SQLException, DKUSecurityException {
        if (DatasetInspector.isMetastoreAssociatedType(this.inputDataset)) {
            HiveConnection connection = new HiveConnection(null);
            connection.params = new HiveConnection.Params();
            connection.params.db = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(this.inputDataset);
            return connection;
        }
        return DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(this.authCtxService.getAuthCtx(), this.inputDataset);
    }
}

