/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.sql.FinalSchemaCaster;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ShakerSQLTranslator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.sqltranslator");

    public TranslatorResult translate(AuthCtx authCtx, String contextProjectKey, List<ProcessorScriptStep> steps, Schema inputSchema, SQLUtils.SQLTable inputTable, AbstractSQLConnection conn, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, DatasetHandler.DatasetParams sourceDatasetParams, boolean isDatasetManaged, ShakerSQLTranslatorContext context) throws Exception {
        TranslatorResult ret = new TranslatorResult();
        SQLQueryWithSchema queryChain = new SQLQueryWithSchema();
        SQLDialect dialect = conn.getDialect();
        queryChain.setDialect(dialect);
        queryChain.from(inputTable, "__input_table");
        if (sourcePartitionScheme != null && sourcePartitionScheme.isPartitioned() && sourcePartitions != null && !sourcePartitions.isEmpty()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(sourcePartitionScheme, inputSchema, sourceDatasetParams, sourcePartitions, isDatasetManaged, dialect);
            queryChain.where(partitionFilterExpression);
        }
        queryChain.initWithSchema(inputSchema);
        boolean needsInitialSubQuery = false;
        for (SchemaColumn col : inputSchema.getColumns()) {
            if (col.getType() == Type.DATE && col.timestampNoTzAsDate && !isDatasetManaged) {
                ExpressionBuilder column = queryChain.col(col.getName());
                column = dialect.supportsFromTimezoneNtzOperator() ? column.convertFromTzWithNtz(ShakerSQLTranslator.getAssumedTzForUnknownTz(sourceDatasetParams)) : column.convertFromTz(ShakerSQLTranslator.getAssumedTzForUnknownTz(sourceDatasetParams));
                queryChain.select(column, col.getName());
                needsInitialSubQuery = true;
                continue;
            }
            if (dialect.needCast(col, isDatasetManaged)) {
                queryChain.select(dialect.cast(col, queryChain.col(col.getName())), col.getName());
                needsInitialSubQuery = true;
                continue;
            }
            queryChain.select(col.getName());
        }
        if (needsInitialSubQuery) {
            queryChain = queryChain.makeSubquery();
        }
        logger.infoV("Translating %d processors to SQL", new Object[]{steps.size()});
        try {
            String sql = queryChain.prettyPrint(dialect, context);
            logger.info((Object)"Initial SQLQueryWith Schema");
            logger.info((Object)sql);
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot translate expression", (Throwable)e);
        }
        for (ProcessorScriptStep pss : steps) {
            if (pss.disabled) {
                logger.info((Object)("Processor " + pss.type + " is disabled, not translating"));
                continue;
            }
            logger.info((Object)"----------------");
            logger.info((Object)("Translating processor " + pss.type));
            ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(pss);
            ProcessorMeta.ProcessorCapabilitiesSummary caps = meta.getCapabilities(pss.params, pss.designTimeReport, dialect, conn);
            assert (caps.can(ProcessorCapabilities.SQL_TRANSLATABLE)) : "Not SQL translatable";
            ProcessorSQLTranslator translator = meta.getSQLTranslator(pss.params, pss.designTimeReport, conn);
            queryChain = translator.translate(authCtx, contextProjectKey, context, queryChain);
            if (translator instanceof SnowflakeUDFProcessorTranslator) {
                ret.snowflakeUDFResources.addAll(((SnowflakeUDFProcessorTranslator)translator).getUDFResources());
                ret.snowflakeUDFs.addAll(((SnowflakeUDFProcessorTranslator)translator).getUDFs());
            }
            try {
                String sql = queryChain.prettyPrint(dialect, context);
                logger.info((Object)("After " + pss.type + ":\n" + sql));
            }
            catch (Exception e) {
                logger.warn((Object)"Cannot translate expression", (Throwable)e);
            }
        }
        ret.translated = queryChain;
        return ret;
    }

    public TranslatorResult translateAndCast(AuthCtx authCtx, String contextProjectKey, List<ProcessorScriptStep> steps, Schema inputSchema, SQLUtils.SQLTable inputTable, AbstractSQLConnection conn, Dataset outputDataset, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, DatasetHandler.DatasetParams sourceDatasetParams, PartitioningScheme targetPartitionScheme, Partition targetPartition, boolean isDatasetManaged, ShakerSQLTranslatorContext shakerSQLTranslatorContext) throws Exception {
        TranslatorResult ret = this.translate(authCtx, contextProjectKey, steps, inputSchema, inputTable, conn, sourcePartitionScheme, sourcePartitions, sourceDatasetParams, isDatasetManaged, shakerSQLTranslatorContext);
        if (targetPartitionScheme != null && targetPartitionScheme.isPartitioned() && targetPartition != null && !targetPartition.isAll() && !targetPartition.isNP()) {
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            for (Map.Entry dimension : targetPartition.getDimensionValues().entrySet()) {
                String name = (String)dimension.getKey();
                SchemaColumn schemaColumn = outputDataset.getSchema().getColumn(name);
                ExpressionBuilder expressionBuilder = ebf.dstPartitionValue(schemaColumn, (DimensionValue)dimension.getValue(), conn.getDialect());
                ret.translated.addLastOrReplaceColumn(schemaColumn, expressionBuilder, schemaColumn.getType(), name);
            }
        }
        ret.translated = new FinalSchemaCaster().getCasted(ret.translated, outputDataset.getSchema());
        ret.translated.applyInsertIntoCasts(outputDataset);
        return ret;
    }

    private static String getAssumedTzForUnknownTz(DatasetHandler.DatasetParams config) {
        String tz = null;
        if (config instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            tz = ((AbstractSQLDatasetHandler.AbstractSQLConfig)config).getAssumedDBTzForUnknownTz();
        }
        if (tz == null || tz.length() == 0) {
            tz = DateTimeZone.getDefault().getID();
        }
        return tz;
    }

    public static class TranslatorResult {
        public SQLQueryWithSchema translated;
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> snowflakeUDFResources = new ArrayList<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource>();
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> snowflakeUDFs = new ArrayList<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef>();
    }

    public static enum ShakerSQLTranslatorContext {
        RECIPE_STATUS_COMPUTE,
        RECIPE_RUN,
        STREAMING_WITH_STEPS;

    }
}

