/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sqlnotebooks;

import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SQLNotebook
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    @JSON.FileTransient
    public boolean isRunning;
    @JSON.FileTransient
    public SQLNotebookType language;
    public String analyzedDataset;
    public String connection;
    public String name;
    @Nullable
    public String recipeId;
    public List<SQLNotebookCell> cells = new ArrayList<SQLNotebookCell>();
    public boolean automationLocal;

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.SQL_NOTEBOOK;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public static class SQLNotebookListItem
    extends TaggableObjectsService.TaggableListItem {
        public final String connection;
        public final boolean isRunning;
        public final String analyzedDataset;
        public final SQLNotebookType language;
        public String connectionDisplayName;

        public SQLNotebookListItem(SQLNotebook nbk) {
            super(nbk);
            this.connection = nbk.connection;
            this.isRunning = nbk.isRunning;
            this.language = nbk.language;
            this.connectionDisplayName = nbk.connection;
            this.analyzedDataset = nbk.analyzedDataset;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.SQL_NOTEBOOK;
        }
    }

    public static class SQLNotebookCell {
        public String id;
        public SQLNotebookCellType type;
        public String name;
        public String code;
        public SQLNotebookQuery.QuerySettings querySettings = new SQLNotebookQuery.QuerySettings();
    }

    public static enum SQLNotebookType {
        SQL,
        HIVE,
        IMPALA,
        SPARKSQL;

    }

    public static enum SQLNotebookCellType {
        QUERY,
        MARKDOWN;

    }
}

