/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.sql.queries.AddColumnQueryBuilder;
import com.dataiku.dip.timelines.MultiTimelinesInternalDB;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.utils.DKULogger;
import java.sql.Statement;

public class ProjectTimelineInternalDB
extends AbstractDSSDBService {
    private static final int SCHEMA_VERSION = 5;
    static final int MAX_TIMELINE_SIZE_PER_OBJECT = 80;
    public final ProjectTimelineBehavior behavior;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    public ProjectTimelineInternalDB(String projectKey) {
        super(MultiTimelinesInternalDB.getProjectDAOFile(projectKey), "timeline_" + projectKey, "timeline", 5, false);
        this.behavior = new ProjectTimelineBehavior(projectKey, this.resolveTable("TIMELINE_ITEM"), this.getDialect());
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) {
        try {
            Statement st2;
            String timelineTable = "TIMELINE_ITEM";
            SchemaColumn[] timelineColumns = ProjectTimelineBehavior.timelineColumns;
            if (currentSchemaVersion == 0) {
                st2 = conn.createStatement();
                try {
                    this.createTable(timelineTable, timelineColumns, new String[0], st2);
                    this.createAnonymousIndex(timelineTable, new String[]{"PROJECT_KEY"}, st2);
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            if (currentSchemaVersion < 3) {
                st2 = conn.createStatement();
                try {
                    logger.info((Object)("Create indexes for " + this.getName()));
                    this.createAnonymousIndex(timelineTable, new String[]{"OBJECT_TYPE", "OBJECT_ID"}, st2);
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            if (currentSchemaVersion > 0 && currentSchemaVersion <= 4) {
                st2 = conn.createStatement();
                try {
                    String timelineTableName = "TIMELINE_ITEM";
                    logger.debugV("Adding a project key column to the timeline table of project %s", new Object[]{this.behavior.projectKey});
                    AddColumnQueryBuilder.addColumnTo(this.resolveTable(timelineTableName)).addColumns(ProjectTimelineBehavior.PROJECT_KEY_SCHEMA_COLUMN).execute(st2, this.getDialect());
                    this.createAnonymousIndex(timelineTableName, new String[]{ProjectTimelineBehavior.PROJECT_KEY_SCHEMA_COLUMN.getName()}, st2);
                    String fillColumnQuery = String.format("UPDATE %s SET %s = '%s'", this.getDialect().quoteIdentifier(timelineTableName), this.getDialect().quoteIdentifier(ProjectTimelineBehavior.PROJECT_KEY_SCHEMA_COLUMN.getName()), this.behavior.projectKey);
                    logger.debugV("Filling column with project key value: %s", new Object[]{this.behavior.projectKey});
                    st2.execute(fillColumnQuery);
                    logger.debug((Object)"New column added and filled with project key");
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            if (currentSchemaVersion > 1 && currentSchemaVersion < 4) {
                try {
                    logger.info((Object)"Migrate comments");
                    this.behavior.migrateCommentsToDiscussions(conn);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to migrate comments from project " + this.behavior.projectKey + ". Proceeding."), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to init timeline. ProjectKey: " + this.behavior.projectKey), (Throwable)e);
        }
    }

    @Override
    public void deleteConnectionPool() {
        super.deleteConnectionPool();
    }
}

