/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.CreateTableQueryBuilder;
import com.dataiku.dip.timelines.workspace.AbstractWorkspaceTimelinesService;
import com.dataiku.dip.timelines.workspace.IWorkspaceTimelinesDBService;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineBehavior;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineItem;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelinesService;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SingleWorkspaceTimelinesInternalDB
extends AbstractDSSDBService
implements IWorkspaceTimelinesDBService {
    private static final int SCHEMA_VERSION = 1;
    private final Map<String, WorkspaceTimelineBehavior> timelines = new ConcurrentHashMap<String, WorkspaceTimelineBehavior>();
    private final DefaultWorkspaceTimelinesDAO defaultWorkspaceTimelinesDAO = new DefaultWorkspaceTimelinesDAO();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.timelines.workspace");

    private static File getFakeWorkspaceDAOFile() {
        return new File(ApplicationConfigurator.getBaseFolderF(), "timelines/workspace/any");
    }

    public SingleWorkspaceTimelinesInternalDB() throws CodedSQLException {
        super(SingleWorkspaceTimelinesInternalDB.getFakeWorkspaceDAOFile(), "workspaceTimeline", "workspaceTimeline", 1, false);
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        block8: {
            try {
                if (currentSchemaVersion != 0) break block8;
                try (Statement st2 = conn.createStatement();){
                    CreateTableQueryBuilder.createTable(this.resolveTable("WORKSPACE_TIMELINE_ITEM")).addColumns(WorkspaceTimelineBehavior.TIMELINE_COLUMNS).execute(st2, this.getDialect());
                    CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable("WORKSPACE_TIMELINE_ITEM")).addColumns("WORKSPACE_KEY").execute(st2, this.getDialect());
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to init single workspace timeline.", (Throwable)e);
            }
        }
    }

    @Override
    public DSSDBConnection acquireConnection(String workspaceKey, boolean isReadOnly) throws CodedSQLException {
        return this.acquireConnection(isReadOnly);
    }

    @Override
    public DSSDBConnection acquireConnection(String workspaceKey) throws CodedSQLException {
        return this.acquireConnection(workspaceKey, false);
    }

    @Override
    public void createWorkspace(String workspaceKey) throws CodedSQLException {
        this.defaultWorkspaceTimelinesDAO.createWorkspace(workspaceKey);
    }

    @Override
    public void deleteForWorkspace(String workspaceKey) {
        this.defaultWorkspaceTimelinesDAO.deleteForWorkspace(workspaceKey);
    }

    @Override
    public void insert(WorkspaceTimelineItem ti) throws CodedSQLException {
        this.defaultWorkspaceTimelinesDAO.insert(ti);
    }

    @Override
    public void update(WorkspaceTimelineItem ti) throws CodedSQLException {
        this.defaultWorkspaceTimelinesDAO.update(ti);
    }

    @Override
    public WorkspaceTimelinesService.WorkspaceTimelineWithVersioning getForWorkspace(String workspaceKey, int from, int limit) throws CodedSQLException {
        return this.defaultWorkspaceTimelinesDAO.getForWorkspace(workspaceKey, from, limit);
    }

    @Override
    public WorkspaceTimelineBehavior getDao(String workspaceKey) throws CodedSQLException {
        return this.defaultWorkspaceTimelinesDAO.getDao(workspaceKey);
    }

    @Override
    public WorkspaceTimelineItem getFirstForObject(String workspaceKey, ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        return this.defaultWorkspaceTimelinesDAO.getFirstForObject(workspaceKey, objectType, projectKey, objectId);
    }

    @Override
    public WorkspaceTimelineItem getLatestForObject(String workspaceKey, ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        return this.defaultWorkspaceTimelinesDAO.getLatestForObject(workspaceKey, objectType, projectKey, objectId);
    }

    @Override
    public WorkspaceTimelineItem getLatestForUser(String workspaceKey, String userId) throws CodedSQLException {
        return this.defaultWorkspaceTimelinesDAO.getLatestForUser(workspaceKey, userId);
    }

    @Override
    public WorkspaceTimelineItem getLatest(String workspaceKey) throws CodedSQLException {
        return this.defaultWorkspaceTimelinesDAO.getLatest(workspaceKey);
    }

    private class DefaultWorkspaceTimelinesDAO
    extends AbstractWorkspaceTimelinesService {
        private DefaultWorkspaceTimelinesDAO() {
        }

        @Override
        public DSSDBConnection acquireConnection(String workspaceKey, boolean isReadOnly) throws CodedSQLException {
            return SingleWorkspaceTimelinesInternalDB.this.acquireConnection(isReadOnly);
        }

        @Override
        public void createWorkspace(String workspaceKey) throws CodedSQLException {
            if (SingleWorkspaceTimelinesInternalDB.this.timelines.containsKey(workspaceKey)) {
                logger.warnV("Workspace timeline DAO already created for %s", new Object[]{workspaceKey});
                return;
            }
            WorkspaceTimelineBehavior behavior = new WorkspaceTimelineBehavior(workspaceKey, SingleWorkspaceTimelinesInternalDB.this.resolveTable("WORKSPACE_TIMELINE_ITEM"), SingleWorkspaceTimelinesInternalDB.this.getDialect());
            try (DSSDBConnection conn = super.acquireConnection(workspaceKey);){
                behavior.fetchInitialUIData(conn);
            }
            SingleWorkspaceTimelinesInternalDB.this.timelines.put(workspaceKey, behavior);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteForWorkspace(String workspaceKey) {
            try (DSSDBConnection conn = super.acquireConnection(workspaceKey);){
                this.getDao(workspaceKey).delete(conn);
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to delete workspace timeline for %s", new Object[]{workspaceKey});
            }
            finally {
                SingleWorkspaceTimelinesInternalDB.this.timelines.remove(workspaceKey);
            }
        }

        @Override
        public WorkspaceTimelineBehavior getDao(String workspaceKey) throws CodedSQLException {
            if (!SingleWorkspaceTimelinesInternalDB.this.timelines.containsKey(workspaceKey)) {
                logger.debugV("Creating DAO for workspace timeline %s", new Object[]{workspaceKey});
                this.createWorkspace(workspaceKey);
            }
            return SingleWorkspaceTimelinesInternalDB.this.timelines.get(workspaceKey);
        }
    }
}

