/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.savedmodels.externalmodelidentifier.ExternalEndpointIdentifier;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.NodesService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDesignCRUDService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringModelStatusComputationService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringPaths;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringProxySMV;
import com.dataiku.dip.unifiedmonitoring.payloads.UnifiedMonitoringProxySMVWithModelStatus;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringDesignComputationService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UnifiedMonitoringDesignCRUDService unifiedMonitoringDesignCRUDService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private NodesService nodesService;
    @Autowired
    private UnifiedMonitoringModelStatusComputationService unifiedMonitoringModelStatusComputationService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedMonitoringDesignComputationService");

    @PostConstruct
    public void init() {
        try {
            if (!this.nodesService.isDesignNode()) {
                return;
            }
            if (!FeatureFlags.isEnabled((String)"unifiedMonitoring.preserveDataOnStartup")) {
                logger.infoV("Starting up, clearing Unified Monitoring design directory", new Object[0]);
                File unifiedMonitoringDesignDirectory = UnifiedMonitoringPaths.getDesignBaseDir();
                try {
                    DKUFileUtils.deleteDirectory((File)unifiedMonitoringDesignDirectory);
                }
                catch (IOException e) {
                    logger.errorV((Throwable)e, "Unable to clear directory: %s", new Object[]{unifiedMonitoringDesignDirectory});
                }
            }
            this.computeInitialProxySMVListing();
        }
        catch (Exception e) {
            logger.fatal((Object)"UnifiedMonitoringDesignComputationService could not be initialized properly", (Throwable)e);
        }
    }

    public ModelStatus getOrComputeModelStatus(String projectKey, FullModelId fullModelId, @Nullable List<String> mesToFilterOn) throws Exception {
        return this.unifiedMonitoringModelStatusComputationService.getOrComputeModelStatus(projectKey, fullModelId, mesToFilterOn);
    }

    private void computeInitialProxySMVListing() throws Exception {
        DSSAuthCtx auth = DSSAuthCtx.internalAdminAuth();
        ArrayList proxySavedModels = new ArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            List projectKeys = this.projectsService.listAccessibleUnsafe((AuthCtx)auth, false).stream().map(project -> project.projectKey).collect(Collectors.toList());
            Iterator<Object> iterator = projectKeys.iterator();
            while (iterator.hasNext()) {
                String projectKey = (String)iterator.next();
                proxySavedModels.addAll(this.savedModelsCRUDService.list(projectKey).stream().filter(sm -> SavedModel.SavedModelType.PROXY_MODEL.equals((Object)sm.savedModelType)).collect(Collectors.toList()));
            }
        }
        ArrayList<FullModelId> proxySavedModelVersions = new ArrayList<FullModelId>();
        for (SavedModel savedModel : proxySavedModels) {
            proxySavedModelVersions.addAll(this.predictionSMMgmtService.listUsableVersions(savedModel));
        }
        ArrayList<UnifiedMonitoringProxySMV> unifiedMonitoringProxySMVS = new ArrayList<UnifiedMonitoringProxySMV>();
        for (FullModelId fmi : proxySavedModelVersions) {
            ExternalEndpointIdentifier externalEndpointIdentifier;
            MLFlowModelVersionInfo mvi = fmi.getMLflowImportedModelMetadata();
            if (mvi == null || mvi.proxyModelVersionConfiguration == null || mvi.proxyModelVersionConfiguration.proxyModelConfiguration == null) {
                logger.infoV("Could not retrieve proxy model configuration for SMV %s; it will be listed for unified monitoring without external model identifier", new Object[]{fmi.toString()});
                externalEndpointIdentifier = null;
            } else {
                externalEndpointIdentifier = fmi.getMLflowImportedModelMetadata().getExternalEndpointIdentifier();
            }
            if (externalEndpointIdentifier == null) {
                logger.warnV("No external model identifier has been found for proxy model %s", new Object[]{fmi.toString()});
            }
            unifiedMonitoringProxySMVS.add(new UnifiedMonitoringProxySMV(externalEndpointIdentifier, fmi));
        }
        this.unifiedMonitoringDesignCRUDService.save(unifiedMonitoringProxySMVS);
    }

    public void updateProxyModelListing(String projectKey, String savedModelId) throws IOException {
        List<Object> proxySmvs = new ArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            SavedModel sm = this.savedModelsCRUDService.getOrNull(projectKey, savedModelId);
            if (sm != null) {
                proxySmvs = this.predictionSMMgmtService.listUsableVersions(sm);
            }
        }
        ArrayList<UnifiedMonitoringProxySMV> proxySmvsWithConfig = new ArrayList<UnifiedMonitoringProxySMV>();
        for (FullModelId fullModelId : proxySmvs) {
            proxySmvsWithConfig.add(new UnifiedMonitoringProxySMV(Objects.requireNonNull(fullModelId.getMLflowImportedModelMetadata()).getExternalEndpointIdentifier(), fullModelId));
        }
        TransactionContext.assertNoAttachedTransaction();
        List<UnifiedMonitoringProxySMV> preProxyModelVersions = this.unifiedMonitoringDesignCRUDService.getCachedProxyModelVersionsList();
        List<UnifiedMonitoringProxySMV> list = preProxyModelVersions.stream().filter(proxyConfig -> !proxyConfig.fullModelId.getSavedModelID().equals(savedModelId) || !proxyConfig.fullModelId.getProjectKey().equals(projectKey)).collect(Collectors.toList());
        list.addAll(proxySmvsWithConfig);
        this.unifiedMonitoringDesignCRUDService.save(list);
        logger.infoV("The proxy model versions will be listed for unified monitoring : %s", new Object[]{proxySmvs.stream().map(FullModelId::toString).collect(Collectors.toList())});
    }

    public void deleteProxyModelVersionListing(FullModelId fmi) throws IOException {
        if (fmi.type == FullModelId.Type.SAVED) {
            SavedModel savedModel;
            try (Transaction t = this.transactionService.beginRead();){
                savedModel = this.savedModelsCRUDService.getOrNullUnsafe(fmi.getProjectKey(), fmi.getSavedModelID());
            }
            if (savedModel.savedModelType.equals((Object)SavedModel.SavedModelType.PROXY_MODEL)) {
                this.unifiedMonitoringDesignCRUDService.deleteProxyModelVersionListing(fmi);
            }
        }
    }

    public List<UnifiedMonitoringProxySMVWithModelStatus> listProxySmvWithModelStatus() throws Exception {
        ArrayList<UnifiedMonitoringProxySMVWithModelStatus> resp = new ArrayList<UnifiedMonitoringProxySMVWithModelStatus>();
        List<UnifiedMonitoringProxySMV> proxySMVs = this.unifiedMonitoringDesignCRUDService.getCachedProxyModelVersionsList();
        for (UnifiedMonitoringProxySMV proxySmv : proxySMVs) {
            UnifiedMonitoringProxySMVWithModelStatus unifiedMonitoringProxySMVWithModelStatus = new UnifiedMonitoringProxySMVWithModelStatus(proxySmv);
            if (this.isActiveProxySmv(proxySmv.fullModelId)) {
                try {
                    unifiedMonitoringProxySMVWithModelStatus.modelStatus = this.getOrComputeModelStatus(proxySmv.fullModelId.getProjectKey(), proxySmv.fullModelId, null);
                }
                catch (Exception e) {
                    logger.info((Object)String.format("Failure trying to get the model status of proxy smv %s", proxySmv.fullModelId.toString()), (Throwable)e);
                }
            }
            resp.add(unifiedMonitoringProxySMVWithModelStatus);
        }
        return resp;
    }

    private boolean isActiveProxySmv(FullModelId fullModelId) {
        boolean bl;
        block8: {
            Transaction t = this.transactionService.beginRead();
            try {
                SavedModel sm = this.savedModelsCRUDService.getMandatoryUnsafe(fullModelId.getProjectKey(), fullModelId.getSavedModelID());
                bl = Objects.equals(sm.getActiveVersion(), fullModelId.getSavedModelVersionID());
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.info((Object)String.format("Could not find the proxy sm of smv %s, skipping its listing for unified monitoring", fullModelId), (Throwable)e);
                    return false;
                }
            }
            t.close();
        }
        return bl;
    }
}

