/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@UIModel
public class AnyLoc
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String projectKey;
    private String id;

    public AnyLoc(String projectKey, String name) {
        this.projectKey = projectKey;
        this.id = name;
    }

    public String getFullName() {
        return this.projectKey + "." + this.id;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getId() {
        return this.id;
    }

    public String getSmartName(String contextProjectKey) {
        if (this.projectKey.equals(contextProjectKey)) {
            return this.id;
        }
        return this.getFullName();
    }

    public AnyLoc resolved() {
        return AnyLoc.resolveSmart(this.projectKey, this.id);
    }

    public DatasetLocUtils.DatasetLoc toDatasetLoc() {
        return new DatasetLocUtils.DatasetLoc(this.projectKey, this.id);
    }

    public String toString() {
        return this.getFullName();
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnyLoc) {
            AnyLoc loc = (AnyLoc)obj;
            return Objects.equals(loc.projectKey, this.projectKey) && Objects.equals(loc.id, this.id);
        }
        return false;
    }

    public static AnyLoc resolveSmart(String contextProjectKey, @Nonnull String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Invalid loc: empty name");
        if (name.contains(".")) {
            String[] chunks = StringUtils.split((String)name, (String)".");
            if (chunks.length < 2) {
                throw new IllegalArgumentException(String.format("Invalid object id '%s'", name));
            }
            return new AnyLoc(chunks[0], chunks[1]);
        }
        if (contextProjectKey == null) {
            throw new IllegalArgumentException("A full object name (in the form PROJECT_KEY.ID) is required");
        }
        return new AnyLoc(contextProjectKey, name);
    }

    @Nullable
    public static AnyLoc resolveSmartNullSafe(String projectKey, @Nullable String usedDataset) {
        AnyLoc datasetLocation = null;
        if (usedDataset != null) {
            datasetLocation = AnyLoc.resolveSmart(projectKey, usedDataset);
        }
        return datasetLocation;
    }

    public static AnyLoc resolveFull(String fullName) {
        if (fullName.contains(".")) {
            String[] chunks = StringUtils.split((String)fullName, (String)".");
            return new AnyLoc(chunks[0], chunks[1]);
        }
        throw new IllegalArgumentException("A full object name (in the form PROJECT_KEY.ID) is required");
    }

    public static AnyLoc resolveWithEnvDefault(String name) {
        if (name.contains(".")) {
            String[] chunks = StringUtils.split((String)name, (String)".");
            return new AnyLoc(chunks[0], chunks[1]);
        }
        if (RemoteRunEnvHelper.getEnv("DKU_DEFAULT_PROJECT") == null) {
            throw new IllegalArgumentException("No DKU_DEFAULT_PROJECT env variable, a full object name (in the form PROJECT_KEY.ID) is required");
        }
        return new AnyLoc(RemoteRunEnvHelper.getEnv("DKU_DEFAULT_PROJECT"), name);
    }
}

