/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.gson.JsonObject;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.HasFields;
import com.google.refine.expr.HasFieldsList;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Get
implements Function {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object call(Properties bindings, Object[] args) {
        int end;
        int start;
        if (args.length <= 1) return null;
        if (args.length > 3) return null;
        Object v = args[0];
        Object from = args[1];
        Object to = args.length == 3 ? args[2] : null;
        if (v == null) return null;
        if (from == null) return null;
        if (v instanceof HasFields && from instanceof String) {
            return ((HasFields)v).getField((String)from, bindings);
        }
        if (v instanceof JSONObject && from instanceof String) {
            try {
                JSONObject asJson = (JSONObject)v;
                String key = (String)from;
                if (!asJson.has(key)) return to;
                if (asJson.isNull(key)) return to;
                return asJson.get(key);
            }
            catch (JSONException e) {
                return to;
            }
        }
        if (v instanceof JsonObject && from instanceof String) {
            JsonObject asJson = (JsonObject)v;
            String key = (String)from;
            if (!asJson.has(key)) return to;
            if (asJson.get(key).isJsonNull()) return to;
            return asJson.get((String)from);
        }
        if (!(from instanceof Number)) return null;
        if (to != null) {
            if (!(to instanceof Number)) return null;
        }
        if (v.getClass().isArray() || v instanceof List || v instanceof HasFieldsList || v instanceof JSONArray) {
            int length = 0;
            length = v.getClass().isArray() ? ((Object[])v).length : (v instanceof HasFieldsList ? ((HasFieldsList)v).length() : (v instanceof JSONArray ? ((JSONArray)v).length() : ExpressionUtils.toObjectList(v).size()));
            start = ((Number)from).intValue();
            if (start < 0) {
                start = length + start;
            }
            start = Math.min(length, Math.max(0, start));
            if (to == null) {
                if (v.getClass().isArray()) {
                    return ((Object[])v)[start];
                }
                if (v instanceof HasFieldsList) {
                    return ((HasFieldsList)v).get(start);
                }
                if (!(v instanceof JSONArray)) return ExpressionUtils.toObjectList(v).get(start);
                try {
                    return ((JSONArray)v).get(start);
                }
                catch (JSONException jSONException) {
                    return null;
                }
            }
            end = ((Number)to).intValue();
            if (end < 0) {
                end = length + end;
            }
            if ((end = Math.min(length, Math.max(start, end))) <= start) return null;
            if (v.getClass().isArray()) {
                Object[] a2 = new Object[end - start];
                System.arraycopy(v, start, a2, 0, end - start);
                return a2;
            }
            if (v instanceof HasFieldsList) {
                return ((HasFieldsList)v).getSubList(start, end);
            }
        } else {
            String s = v instanceof String ? (String)v : v.toString();
            int start2 = ((Number)from).intValue();
            if (start2 < 0) {
                start2 = s.length() + start2;
            }
            start2 = Math.min(s.length(), Math.max(0, start2));
            if (to == null) return s.substring(start2, start2 + 1);
            int end2 = ((Number)to).intValue();
            if (end2 < 0) {
                end2 = s.length() + end2;
            }
            end2 = Math.min(s.length(), Math.max(start2, end2));
            return s.substring(start2, end2);
        }
        if (!(v instanceof JSONArray)) return ExpressionUtils.toObjectList(v).subList(start, end);
        JSONArray a = (JSONArray)v;
        Object[] a2 = new Object[end - start];
        int i = 0;
        while (i < a2.length) {
            try {
                a2[i] = a.get(start + i);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            ++i;
        }
        return a2;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Get.DOCUMENTATION", "If <code>o</code> is an array, returns the item at index <code>from</code>.<br/>If <code>o</code> is a string, returns the character at index <code>from</code>.<br/>If <code>o</code> is an object, returns the value corresponding to the field <code>from</code> or <code>default</code> if it is empty.").withParams("o, number of string from, [default]").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("[1,2,3,4,5]", "2").returns("3")).withExample(Example.with("\"hello\"", "1").returns("e"));
    }
}

