/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class Hash
implements Function {
    private HashFunction func = Hashing.goodFastHash((int)64);

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return 0;
        }
        if (args.length == 1) {
            Object o1 = args[0];
            if (o1 == null) {
                return 0;
            }
            String s1 = o1.toString();
            long l = this.func.hashString((CharSequence)s1, StandardCharsets.UTF_8).asLong();
            return Math.abs(l);
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects only 1 argument");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Hash.DOCUMENTATION", "Returns a 64 bits numerical hash of the input (not crypto-secure).").withParams("string").withReturns("long").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("\"goo\"").returns("2774880816139997119"));
    }
}

