/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Partition
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length >= 2 && args.length <= 3) {
            Object o3;
            Object o1 = args[0];
            Object o2 = args[1];
            boolean omitFragment = false;
            if (args.length == 3 && (o3 = args[2]) instanceof Boolean) {
                omitFragment = (Boolean)o3;
            }
            if (o2 != null && o1 instanceof String) {
                String[] output;
                Pattern pattern;
                Matcher matcher;
                String s = (String)o1;
                int from = -1;
                int to = -1;
                if (o2 instanceof String) {
                    String frag = (String)o2;
                    from = s.indexOf(frag);
                    to = from + frag.length();
                } else if (o2 instanceof Pattern && (matcher = (pattern = (Pattern)o2).matcher(s)).find()) {
                    from = matcher.start();
                    to = matcher.end();
                }
                String[] stringArray = output = omitFragment ? new String[2] : new String[3];
                if (from > -1) {
                    output[0] = s.substring(0, from);
                    if (omitFragment) {
                        output[1] = s.substring(to);
                    } else {
                        output[1] = s.substring(from, to);
                        output[2] = s.substring(to);
                    }
                } else {
                    output[0] = s;
                    output[1] = "";
                    if (!omitFragment) {
                        output[2] = "";
                    }
                }
                return output;
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Partition.DOCUMENTATION", "Returns an array of strings <code>[a,frag,b]</code> where <code>a</code> is the part before the first occurrence of <code>frag</code> in <code>s</code> and <code>b</code> is the part after the occurrence. If <code>omitFragment</code> is true, <code>frag</code> is not returned in the array.").withParams("string s, string or regex frag, [boolean omitFragment]").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"", "\"wo\"").returns("[\"hello \",\"wo\",\"rld\"]"));
    }
}

