/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.buffer.BufferEntry;
import com.atilika.kuromoji.compile.Compiler;
import com.atilika.kuromoji.io.ByteBufferIO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class TokenInfoBufferCompiler
implements Compiler {
    private static final int INTEGER_BYTES = 4;
    private static final int SHORT_BYTES = 2;
    private ByteBuffer buffer;
    private OutputStream output;

    public TokenInfoBufferCompiler(OutputStream output, List<BufferEntry> entries) {
        this.output = output;
        this.putEntries(entries);
    }

    public void putEntries(List<BufferEntry> entries) {
        int size = this.calculateEntriesSize(entries) * 2;
        this.buffer = ByteBuffer.allocate(size + 16);
        this.buffer.putInt(size);
        this.buffer.putInt(entries.size());
        BufferEntry firstEntry = entries.get(0);
        this.buffer.putInt(firstEntry.tokenInfo.size());
        this.buffer.putInt(firstEntry.posInfo.size());
        this.buffer.putInt(firstEntry.features.size());
        for (BufferEntry entry : entries) {
            for (Short s : entry.tokenInfo) {
                this.buffer.putShort(s);
            }
            for (Byte b : entry.posInfo) {
                this.buffer.put(b);
            }
            for (Integer feature : entry.features) {
                this.buffer.putInt(feature);
            }
        }
    }

    private int calculateEntriesSize(List<BufferEntry> entries) {
        if (entries.isEmpty()) {
            return 0;
        }
        int size = 0;
        BufferEntry entry = entries.get(0);
        size += entry.tokenInfo.size() * 2 + 2;
        size += entry.posInfo.size();
        size += entry.features.size() * 4;
        return size *= entries.size();
    }

    @Override
    public void compile() throws IOException {
        ByteBufferIO.write(this.output, this.buffer);
        this.output.close();
    }
}

