/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.hive.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SeparateClassLoaderExecutor {
    private final ClassLoader hiveClassLoader;
    private final ExecutorService executor;
    private static Logger logger = Logger.getLogger(SeparateClassLoaderExecutor.class);

    SeparateClassLoaderExecutor(ClassLoader hiveClassLoader, String name) {
        this.hiveClassLoader = hiveClassLoader;
        ThreadFactory classLoaderSetterFactory = new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable runnable) {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setContextClassLoader(SeparateClassLoaderExecutor.this.hiveClassLoader);
                        runnable.run();
                    }
                });
            }
        };
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(name + "-%d").setThreadFactory(classLoaderSetterFactory).build());
    }

    public SeparateClassLoaderExecutor spawnAnother(String name) {
        return new SeparateClassLoaderExecutor(this.hiveClassLoader, name);
    }

    public ClassLoader getClassLoader() {
        return this.hiveClassLoader;
    }

    public <T> T runFully(Callable<T> callable) throws Exception {
        return this.executor.submit(callable).get();
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    public void run(Runnable runnable) {
        this.executor.submit(runnable);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public void patientShutdownNow(String identifier) throws InterruptedException {
        this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        if (!this.executor.isTerminated()) {
            this.info(identifier, "Tried to kill him... but Hive survived. Last chance: interrupt the thread");
            this.executor.shutdownNow();
        }
    }

    public synchronized void info(String identifier, String str) {
        this.info("[" + identifier + "] " + str);
    }

    public synchronized void info(String identifier, String str, Throwable t) {
        this.info("[" + identifier + "] " + str, t);
    }

    public synchronized void info(String str) {
        logger.info((Object)str);
    }

    public synchronized void info(String str, Throwable t) {
        logger.info((Object)str, t);
    }

    public synchronized void error(String identifier, String str) {
        this.error("[" + identifier + "] " + str);
    }

    public synchronized void error(String identifier, String str, Throwable t) {
        this.error("[" + identifier + "] " + str, t);
    }

    public synchronized void error(String str) {
        logger.error((Object)str);
    }

    public synchronized void error(String str, Throwable t) {
        logger.error((Object)str, t);
    }
}

