/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.dispatch;

import com.dataiku.lambda.dispatch.GenerationSelector;
import com.dataiku.lambda.dispatch.HashBasedGenerationSelector;
import com.dataiku.lambda.dispatch.RandomGenerationSelector;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;

public class GenerationSelectorFactory {
    private GenerationSelectorFactory() {
    }

    public static GenerationSelector build(GenerationsMapping mapping) {
        mapping.validate();
        if (mapping.isSingleGeneration()) {
            return new RandomGenerationSelector(mapping);
        }
        switch (mapping.strategy) {
            case HASH_BASED: {
                return new HashBasedGenerationSelector(mapping);
            }
            case RANDOM: {
                return new RandomGenerationSelector(mapping);
            }
        }
        throw new Error("unreachable");
    }
}

