/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.data.currency;

import com.dataiku.dip.data.currency.Currency;
import com.dataiku.dip.data.currency.CurrencyAmount;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CurrencyExtractionUtils {
    private static Pattern digitsWithSeparatorsPattern = Pattern.compile("^-?[0-9,\\.'\\s]*$");
    private static Pattern separatorsPattern = Pattern.compile("[,\\.'\\s]");

    private static CurrencyAmount findCurrencySign(String in) {
        CurrencyAmount ret = new CurrencyAmount();
        String foundCurrencySign = null;
        Currency foundCurrency = null;
        for (Currency currency : Currency.values()) {
            if (in.contains(currency.getCurrencySignUnicode()) && (foundCurrencySign == null || currency.getCurrencySignUnicode().length() > foundCurrencySign.length())) {
                foundCurrencySign = currency.getCurrencySignUnicode();
                foundCurrency = currency;
                ret.isAmbiguous = foundCurrency.getIsAmbiguous();
            }
            if (!in.contains(currency.name()) || foundCurrencySign != null && currency.name().length() <= foundCurrencySign.length()) continue;
            foundCurrencySign = currency.name();
            foundCurrency = currency;
            ret.isAmbiguous = true;
        }
        if (foundCurrencySign == null) {
            return null;
        }
        ret.currency = foundCurrency;
        ret.foundCurrencySign = foundCurrencySign;
        return ret;
    }

    private static CurrencyAmount findCurrencyAmount(String in, CurrencyAmount foundCurrencyAmount, boolean pristineAmount) {
        Object amount;
        String[] digitParts = StringUtils.split((String)in, (String)foundCurrencyAmount.foundCurrencySign);
        if (digitParts.length > 2) {
            return null;
        }
        if (digitParts.length < 2 || !StringUtils.isBlank((String)digitParts[0]) && StringUtils.isBlank((String)digitParts[1])) {
            amount = digitParts[0];
        } else if (!StringUtils.isBlank((String)digitParts[0]) && !StringUtils.isBlank((String)digitParts[1])) {
            amount = digitParts[0] + foundCurrencyAmount.currency.getDecimalSeparator() + digitParts[1];
        } else if (StringUtils.isBlank((String)digitParts[0])) {
            amount = digitParts[1];
        } else {
            return null;
        }
        String[] splittedAmount = StringUtils.split((String)amount, (String)foundCurrencyAmount.currency.getDecimalSeparator());
        if (splittedAmount.length > 2) {
            return null;
        }
        if (splittedAmount.length == 2 && !StringUtils.isNumericSpace((String)splittedAmount[1])) {
            return null;
        }
        if (!digitsWithSeparatorsPattern.matcher(splittedAmount[0]).matches()) {
            return null;
        }
        if (!pristineAmount) {
            amount = separatorsPattern.matcher(splittedAmount[0]).replaceAll("");
            if (splittedAmount.length == 2) {
                amount = (String)amount + "." + splittedAmount[1].replaceAll("\\s", "");
            }
        }
        foundCurrencyAmount.amount = amount;
        return foundCurrencyAmount;
    }

    public static CurrencyAmount extractCurrencyAmount(String in, boolean pristineAmount) {
        if (StringUtils.isBlank((String)in)) {
            return null;
        }
        if (!Character.isDigit(in.charAt(0)) && in.charAt(0) != '-' && !Character.isDigit(in.charAt(in.length() - 1))) {
            return null;
        }
        CurrencyAmount ret = CurrencyExtractionUtils.findCurrencySign(in);
        if (ret == null) {
            return null;
        }
        return CurrencyExtractionUtils.findCurrencyAmount(in, ret, pristineAmount);
    }
}

