/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class RegexpExtractorAlgorithm
implements Serializable {
    public static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    public static final Pattern NON_CAPTURING_GROUP_PATTERN = Pattern.compile("\\(\\?:");
    public static final Pattern LOOK_AROUND_EXPRESSIONS_PATTERN = Pattern.compile("\\(\\?<?[!=]");
    public static final Pattern BACK_REFERENCE_PATTERN = Pattern.compile("\\\\[0-9]+");
    private final boolean found_col;
    private final boolean extractAllOccurrences;
    private final Pattern pattern;
    private final List<String> namedGroupNames = new ArrayList<String>();
    private final int unnamedGroupCount;
    private final int outputCount;

    public RegexpExtractorAlgorithm(boolean found_col, boolean extractAllOccurrences, String regexp) {
        this.found_col = found_col;
        this.extractAllOccurrences = extractAllOccurrences;
        this.pattern = Pattern.compile(regexp);
        Matcher m = NAMED_GROUP_PATTERN.matcher(regexp);
        while (m.find()) {
            String groupName = m.group(1);
            this.namedGroupNames.add(groupName);
        }
        this.unnamedGroupCount = this.namedGroupNames.size() == 0 ? this.pattern.matcher("x").groupCount() : 0;
        this.outputCount = this.namedGroupNames.size() + this.unnamedGroupCount + (this.found_col ? 1 : 0);
    }

    public static boolean hasNonCapturingGroups(String pattern) {
        return NON_CAPTURING_GROUP_PATTERN.matcher(pattern).find();
    }

    public static boolean hasLookAroundExpressions(String pattern) {
        return LOOK_AROUND_EXPRESSIONS_PATTERN.matcher(pattern).find();
    }

    public static boolean hasBackReferences(String pattern) {
        return BACK_REFERENCE_PATTERN.matcher(pattern).find();
    }

    public static boolean hasNamedGroups(String pattern) {
        return NAMED_GROUP_PATTERN.matcher(pattern).find();
    }

    public List<String> getNamedGroupNames() {
        return this.namedGroupNames;
    }

    public int getUnnamedGroupCount() {
        return this.unnamedGroupCount;
    }

    public List<Object> process(String input) {
        if (input == null) {
            List<Object> res = this.produceNullResultWithoutFoundCol();
            if (this.found_col) {
                res.add(null);
            }
            return res;
        }
        if (this.extractAllOccurrences) {
            return this.produceAllOccurrencesResult(input);
        }
        return this.produceNotAllOccurrencesResult(input);
    }

    private List<Object> produceNullResultWithoutFoundCol() {
        ArrayList<Object> result = new ArrayList<Object>(this.outputCount);
        for (int i = 0; i < this.namedGroupNames.size() + this.unnamedGroupCount; ++i) {
            result.add(null);
        }
        return result;
    }

    private List<Object> produceNotAllOccurrencesResult(String input) {
        Matcher m = this.pattern.matcher(input);
        if (!m.find()) {
            List<Object> res = this.produceNullResultWithoutFoundCol();
            if (this.found_col) {
                res.add(false);
            }
            return res;
        }
        ArrayList<Object> result = new ArrayList<Object>(this.outputCount);
        for (String group : this.namedGroupNames) {
            result.add(m.group(group));
        }
        for (int i = 1; i <= this.unnamedGroupCount; ++i) {
            result.add(m.group(i));
        }
        if (this.found_col) {
            result.add(true);
        }
        return result;
    }

    private List<Object> produceAllOccurrencesResult(String input) {
        ArrayList<Object> result = new ArrayList<Object>(this.outputCount);
        Matcher m = this.pattern.matcher(input);
        HashMap<Object, JSONArray> outs = new HashMap<Object, JSONArray>();
        boolean found = false;
        while (m.find()) {
            found = true;
            for (String groupName : this.namedGroupNames) {
                JSONArray array = (JSONArray)outs.get(groupName);
                if (array == null) {
                    array = new JSONArray();
                    outs.put(groupName, array);
                }
                array.put((Object)m.group(groupName));
            }
            for (int i = 1; i <= this.unnamedGroupCount; ++i) {
                JSONArray array = (JSONArray)outs.get("un_" + i);
                if (array == null) {
                    array = new JSONArray();
                    outs.put("un_" + i, array);
                }
                array.put((Object)m.group(i));
            }
        }
        for (String group : this.namedGroupNames) {
            result.add(outs.get(group));
        }
        for (int i = 1; i <= this.unnamedGroupCount; ++i) {
            result.add(outs.get("un_" + i));
        }
        if (this.found_col) {
            result.add(found);
        }
        return result;
    }
}

