/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.twitter4j;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.twitter.hbc.core.Client;
import com.twitter.hbc.twitter4j.BaseTwitter4jClient;
import com.twitter.hbc.twitter4j.handler.StatusStreamHandler;
import com.twitter.hbc.twitter4j.message.DisconnectMessage;
import com.twitter.hbc.twitter4j.message.StallWarningMessage;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;

public class Twitter4jStatusClient
extends BaseTwitter4jClient {
    private final List<? extends StatusListener> statusListeners;

    public Twitter4jStatusClient(Client client, BlockingQueue<String> blockingQueue, List<? extends StatusListener> listeners, ExecutorService executorService) {
        super(client, blockingQueue, executorService);
        Preconditions.checkNotNull(listeners);
        this.statusListeners = ImmutableList.copyOf(listeners);
    }

    @Override
    protected void onStatus(long sitestreamUser, Status status) {
        for (StatusListener statusListener : this.statusListeners) {
            statusListener.onStatus(status);
        }
    }

    @Override
    protected void onDelete(long sitestreamUser, StatusDeletionNotice delete) {
        for (StatusListener statusListener : this.statusListeners) {
            statusListener.onDeletionNotice(delete);
        }
    }

    @Override
    protected void onTrackLimitationNotice(long sitestreamUser, int limit) {
        for (StatusListener statusListener : this.statusListeners) {
            statusListener.onTrackLimitationNotice(limit);
        }
    }

    @Override
    protected void onScrubGeo(long sitestreamUser, long userId, long upToStatusId) {
        for (StatusListener statusListener : this.statusListeners) {
            statusListener.onScrubGeo(userId, upToStatusId);
        }
    }

    @Override
    protected void onDisconnectMessage(DisconnectMessage disconnect) {
        for (StatusListener statusListener : this.statusListeners) {
            if (!(statusListener instanceof StatusStreamHandler)) continue;
            ((StatusStreamHandler)statusListener).onDisconnectMessage(disconnect);
        }
    }

    @Override
    protected void onStallWarning(StallWarningMessage stallWarning) {
        for (StatusListener statusListener : this.statusListeners) {
            if (!(statusListener instanceof StatusStreamHandler)) continue;
            ((StatusStreamHandler)statusListener).onStallWarningMessage(stallWarning);
        }
    }

    @Override
    protected void onUnknownMessageType(String msg) {
        for (StatusListener statusListener : this.statusListeners) {
            if (statusListener instanceof StatusStreamHandler) {
                ((StatusStreamHandler)statusListener).onUnknownMessageType(msg);
                continue;
            }
            super.onUnknownMessageType(msg);
        }
    }

    @Override
    protected void onException(Exception e) {
        super.onException(e);
        for (StatusListener statusListener : this.statusListeners) {
            statusListener.onException(e);
        }
    }
}

