/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.dataiku.dss.shadelibtd.okhttp3.Response;
import com.dataiku.dss.shadelibtd.okhttp3.internal.http2.StreamResetException;
import com.dataiku.dss.shadelibtd.org.slf4j.Logger;
import com.dataiku.dss.shadelibtd.org.slf4j.LoggerFactory;
import com.treasuredata.client.HttpStatus;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDClientHttpConflictException;
import com.treasuredata.client.TDClientHttpException;
import com.treasuredata.client.TDClientHttpNotFoundException;
import com.treasuredata.client.TDClientHttpTooManyRequestsException;
import com.treasuredata.client.TDClientHttpUnauthorizedException;
import com.treasuredata.client.TDClientInterruptedException;
import com.treasuredata.client.TDClientProcessingException;
import com.treasuredata.client.TDClientSSLException;
import com.treasuredata.client.TDClientSocketException;
import com.treasuredata.client.TDClientTimeoutException;
import com.treasuredata.client.TDHttpClient;
import com.treasuredata.client.TDHttpRequestHandler;
import com.treasuredata.client.model.TDApiErrorMessage;
import java.io.EOFException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;

public class TDRequestErrorHandler {
    private static final String RETRY_AFTER = "Retry-After";
    private static Logger logger = LoggerFactory.getLogger(TDHttpClient.class);
    static final ThreadLocal<SimpleDateFormat> HTTP_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        }
    };

    private TDRequestErrorHandler() {
    }

    private static TDClientHttpException clientError(TDClientHttpException e, TDHttpRequestHandler.ResponseContext responseContext) {
        boolean showWarning = true;
        boolean showStackTrace = false;
        int code = e.getStatusCode();
        switch (code) {
            case 404: {
                showWarning = false;
                break;
            }
            case 409: {
                showStackTrace = false;
                break;
            }
            default: {
                if (HttpStatus.isClientError(code) || HttpStatus.isServerError(code)) break;
                showStackTrace = true;
            }
        }
        if (showWarning) {
            if (showStackTrace) {
                logger.warn(e.getCause() == null ? e.getMessage() : e.getCause().getClass().toString(), e);
            } else {
                logger.warn(e.getCause() == null ? e.getMessage() : e.getCause().getClass().toString());
            }
        }
        return e;
    }

    public static TDClientException defaultHttpResponseErrorResolver(TDHttpRequestHandler.ResponseContext responseContext) throws TDClientException {
        Response response = responseContext.response;
        int code = response.code();
        long now = System.currentTimeMillis();
        Date retryAfter = TDRequestErrorHandler.parseRetryAfter(now, response);
        Optional<TDApiErrorMessage> errorResponse = TDRequestErrorHandler.extractErrorResponse(responseContext.response);
        String responseErrorText = errorResponse.isPresent() ? ": " + errorResponse.get().getText() : "";
        String errorMessage = String.format("[%d:%s] API request to %s has failed%s", code, HttpStatus.getMessage(code), responseContext.apiRequest.getPath(), responseErrorText);
        if (HttpStatus.isClientError(code)) {
            logger.debug(errorMessage);
            switch (code) {
                case 429: {
                    return new TDClientHttpTooManyRequestsException(errorMessage, retryAfter);
                }
                case 401: {
                    throw TDRequestErrorHandler.clientError(new TDClientHttpUnauthorizedException(errorMessage), responseContext);
                }
                case 404: {
                    throw TDRequestErrorHandler.clientError(new TDClientHttpNotFoundException(errorMessage), responseContext);
                }
                case 409: {
                    String conflictsWith = errorResponse.isPresent() ? TDRequestErrorHandler.parseConflictsWith(errorResponse.get()) : null;
                    throw TDRequestErrorHandler.clientError(new TDClientHttpConflictException(errorMessage, conflictsWith), responseContext);
                }
                case 407: {
                    throw TDRequestErrorHandler.clientError(new TDClientHttpException(TDClientException.ErrorType.PROXY_AUTHENTICATION_FAILURE, errorMessage, code, retryAfter), responseContext);
                }
                case 422: {
                    throw TDRequestErrorHandler.clientError(new TDClientHttpException(TDClientException.ErrorType.INVALID_INPUT, errorMessage, code, retryAfter), responseContext);
                }
            }
            throw TDRequestErrorHandler.clientError(new TDClientHttpException(TDClientException.ErrorType.CLIENT_ERROR, errorMessage, code, retryAfter), responseContext);
        }
        if (HttpStatus.isServerError(code)) {
            return TDRequestErrorHandler.clientError(new TDClientHttpException(TDClientException.ErrorType.SERVER_ERROR, errorMessage, code, retryAfter), responseContext);
        }
        throw TDRequestErrorHandler.clientError(new TDClientHttpException(TDClientException.ErrorType.UNEXPECTED_RESPONSE_CODE, errorMessage, code, retryAfter), responseContext);
    }

    public static TDClientException defaultErrorResolver(Throwable e) throws TDClientException {
        if (e instanceof Exception) {
            return TDRequestErrorHandler.defaultExceptionResolver((Exception)e);
        }
        throw new TDClientProcessingException(new RuntimeException(e));
    }

    public static TDClientException defaultExceptionResolver(Exception e) throws TDClientException {
        if (TDClientException.class.isAssignableFrom(e.getClass())) {
            throw (TDClientException)e;
        }
        if (e instanceof ProtocolException || e instanceof ConnectException || e instanceof EOFException) {
            return new TDClientInterruptedException("connection failure", e);
        }
        if (e instanceof TimeoutException || e instanceof SocketTimeoutException) {
            return new TDClientTimeoutException(e);
        }
        if (e instanceof SocketException) {
            SocketException socketException = (SocketException)e;
            if (socketException instanceof BindException || socketException instanceof ConnectException || socketException instanceof NoRouteToHostException || socketException instanceof PortUnreachableException) {
                return new TDClientSocketException(socketException);
            }
            throw new TDClientSocketException(socketException);
        }
        if (e instanceof SSLException) {
            SSLException sslException = (SSLException)e;
            if (sslException instanceof SSLHandshakeException || sslException instanceof SSLKeyException || sslException instanceof SSLPeerUnverifiedException) {
                throw new TDClientSSLException(sslException);
            }
            return new TDClientSSLException(sslException);
        }
        if (e instanceof StreamResetException) {
            Date retryAfter = new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(1L));
            return new TDClientHttpTooManyRequestsException(e.getMessage(), retryAfter);
        }
        if (e.getCause() != null && Exception.class.isAssignableFrom(e.getCause().getClass())) {
            return TDRequestErrorHandler.defaultExceptionResolver((Exception)e.getCause());
        }
        logger.warn("unknown type exception: " + e.getClass(), e);
        throw new TDClientProcessingException(e);
    }

    static Date parseRetryAfter(long now, Response response) {
        String retryAfter = response.header(RETRY_AFTER);
        if (retryAfter == null) {
            return null;
        }
        try {
            long retryAfterSeconds = Long.parseLong(retryAfter);
            return new Date(now + TimeUnit.SECONDS.toMillis(retryAfterSeconds));
        }
        catch (NumberFormatException e) {
            try {
                return HTTP_DATE_FORMAT.get().parse(retryAfter);
            }
            catch (ParseException ignore) {
                logger.warn("Failed to parse Retry-After header: '" + retryAfter + "'");
                return null;
            }
        }
    }

    private static String parseConflictsWith(TDApiErrorMessage errorResponse) {
        Map<String, Object> details = errorResponse.getDetails();
        if (details == null) {
            return null;
        }
        Object conflictsWith = details.get("conflicts_with");
        if (conflictsWith == null) {
            return null;
        }
        return String.valueOf(conflictsWith);
    }

    public static Optional<TDApiErrorMessage> extractErrorResponse(Response response) {
        Optional<Object> content = Optional.empty();
        try {
            try {
                content = Optional.of(response.body().string());
            }
            catch (SocketTimeoutException e) {
                return Optional.of(new TDApiErrorMessage(e.getClass().getSimpleName(), e.getMessage(), "error"));
            }
            catch (IOException e) {
                throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, e);
            }
            if (content.isPresent() && ((String)content.get()).length() > 0 && ((String)content.get()).charAt(0) == '{') {
                return Optional.of(TDHttpClient.defaultObjectMapper.readValue((String)content.get(), TDApiErrorMessage.class));
            }
            return Optional.of(new TDApiErrorMessage("error", (String)content.orElse("[empty]"), "error"));
        }
        catch (IOException e) {
            logger.warn("Failed to parse the error response {}: {}\n{}", response.request().url(), content.orElse("[empty]"), e.getMessage());
            return Optional.empty();
        }
    }
}

