/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.EnableFastLaunchRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.FastLaunchSnapshotConfigurationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class EnableFastLaunchRequestMarshaller
implements Marshaller<Request<EnableFastLaunchRequest>, EnableFastLaunchRequest> {
    @Override
    public Request<EnableFastLaunchRequest> marshall(EnableFastLaunchRequest enableFastLaunchRequest) {
        FastLaunchLaunchTemplateSpecificationRequest launchTemplate;
        FastLaunchSnapshotConfigurationRequest snapshotConfiguration;
        if (enableFastLaunchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableFastLaunchRequest> request = new DefaultRequest<EnableFastLaunchRequest>(enableFastLaunchRequest, "AmazonEC2");
        request.addParameter("Action", "EnableFastLaunch");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableFastLaunchRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(enableFastLaunchRequest.getImageId()));
        }
        if (enableFastLaunchRequest.getResourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString(enableFastLaunchRequest.getResourceType()));
        }
        if ((snapshotConfiguration = enableFastLaunchRequest.getSnapshotConfiguration()) != null && snapshotConfiguration.getTargetResourceCount() != null) {
            request.addParameter("SnapshotConfiguration.TargetResourceCount", StringUtils.fromInteger(snapshotConfiguration.getTargetResourceCount()));
        }
        if ((launchTemplate = enableFastLaunchRequest.getLaunchTemplate()) != null) {
            if (launchTemplate.getLaunchTemplateId() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateId", StringUtils.fromString(launchTemplate.getLaunchTemplateId()));
            }
            if (launchTemplate.getLaunchTemplateName() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateName", StringUtils.fromString(launchTemplate.getLaunchTemplateName()));
            }
            if (launchTemplate.getVersion() != null) {
                request.addParameter("LaunchTemplate.Version", StringUtils.fromString(launchTemplate.getVersion()));
            }
        }
        if (enableFastLaunchRequest.getMaxParallelLaunches() != null) {
            request.addParameter("MaxParallelLaunches", StringUtils.fromInteger(enableFastLaunchRequest.getMaxParallelLaunches()));
        }
        return request;
    }
}

