/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.IpamCidrAuthorizationContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ProvisionIpamPoolCidrRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ProvisionIpamPoolCidrRequestMarshaller
implements Marshaller<Request<ProvisionIpamPoolCidrRequest>, ProvisionIpamPoolCidrRequest> {
    @Override
    public Request<ProvisionIpamPoolCidrRequest> marshall(ProvisionIpamPoolCidrRequest provisionIpamPoolCidrRequest) {
        IpamCidrAuthorizationContext cidrAuthorizationContext;
        if (provisionIpamPoolCidrRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ProvisionIpamPoolCidrRequest> request = new DefaultRequest<ProvisionIpamPoolCidrRequest>(provisionIpamPoolCidrRequest, "AmazonEC2");
        request.addParameter("Action", "ProvisionIpamPoolCidr");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (provisionIpamPoolCidrRequest.getIpamPoolId() != null) {
            request.addParameter("IpamPoolId", StringUtils.fromString(provisionIpamPoolCidrRequest.getIpamPoolId()));
        }
        if (provisionIpamPoolCidrRequest.getCidr() != null) {
            request.addParameter("Cidr", StringUtils.fromString(provisionIpamPoolCidrRequest.getCidr()));
        }
        if ((cidrAuthorizationContext = provisionIpamPoolCidrRequest.getCidrAuthorizationContext()) != null) {
            if (cidrAuthorizationContext.getMessage() != null) {
                request.addParameter("CidrAuthorizationContext.Message", StringUtils.fromString(cidrAuthorizationContext.getMessage()));
            }
            if (cidrAuthorizationContext.getSignature() != null) {
                request.addParameter("CidrAuthorizationContext.Signature", StringUtils.fromString(cidrAuthorizationContext.getSignature()));
            }
        }
        if (provisionIpamPoolCidrRequest.getNetmaskLength() != null) {
            request.addParameter("NetmaskLength", StringUtils.fromInteger(provisionIpamPoolCidrRequest.getNetmaskLength()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(provisionIpamPoolCidrRequest.getClientToken()));
        return request;
    }
}

