/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyTargetGroupRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupRequest>, ModifyTargetGroupRequest> {
    @Override
    public Request<ModifyTargetGroupRequest> marshall(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        Matcher matcher;
        if (modifyTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyTargetGroupRequest> request = new DefaultRequest<ModifyTargetGroupRequest>(modifyTargetGroupRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupRequest.getTargetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString(modifyTargetGroupRequest.getTargetGroupArn()));
        }
        if (modifyTargetGroupRequest.getHealthCheckProtocol() != null) {
            request.addParameter("HealthCheckProtocol", StringUtils.fromString(modifyTargetGroupRequest.getHealthCheckProtocol()));
        }
        if (modifyTargetGroupRequest.getHealthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringUtils.fromString(modifyTargetGroupRequest.getHealthCheckPort()));
        }
        if (modifyTargetGroupRequest.getHealthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringUtils.fromString(modifyTargetGroupRequest.getHealthCheckPath()));
        }
        if (modifyTargetGroupRequest.getHealthCheckEnabled() != null) {
            request.addParameter("HealthCheckEnabled", StringUtils.fromBoolean(modifyTargetGroupRequest.getHealthCheckEnabled()));
        }
        if (modifyTargetGroupRequest.getHealthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringUtils.fromInteger(modifyTargetGroupRequest.getHealthCheckIntervalSeconds()));
        }
        if (modifyTargetGroupRequest.getHealthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringUtils.fromInteger(modifyTargetGroupRequest.getHealthCheckTimeoutSeconds()));
        }
        if (modifyTargetGroupRequest.getHealthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringUtils.fromInteger(modifyTargetGroupRequest.getHealthyThresholdCount()));
        }
        if (modifyTargetGroupRequest.getUnhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringUtils.fromInteger(modifyTargetGroupRequest.getUnhealthyThresholdCount()));
        }
        if ((matcher = modifyTargetGroupRequest.getMatcher()) != null) {
            if (matcher.getHttpCode() != null) {
                request.addParameter("Matcher.HttpCode", StringUtils.fromString(matcher.getHttpCode()));
            }
            if (matcher.getGrpcCode() != null) {
                request.addParameter("Matcher.GrpcCode", StringUtils.fromString(matcher.getGrpcCode()));
            }
        }
        return request;
    }
}

