/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.internal;

import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.handlers.AbstractRequestHandler;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ActivateKeySigningKeyResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.AliasTarget;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ChangeInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.CreateKeySigningKeyResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.CreateReusableDelegationSetResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.DeactivateKeySigningKeyResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.DelegationSet;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.DeleteKeySigningKeyResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.DisableHostedZoneDNSSECResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.EnableHostedZoneDNSSECResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.GetChangeResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.GetHealthCheckResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.GetReusableDelegationSetResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.HealthCheck;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.HostedZone;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ListHealthChecksResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ListReusableDelegationSetsResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.ResourceRecordSet;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.TimingInfo;

public class Route53IdRequestHandler
extends AbstractRequestHandler {
    @Override
    public void afterResponse(Request<?> request, Object obj, TimingInfo timingInfo) {
        if (obj instanceof ChangeResourceRecordSetsResult) {
            ChangeResourceRecordSetsResult result = (ChangeResourceRecordSetsResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof CreateHostedZoneResult) {
            CreateHostedZoneResult result = (CreateHostedZoneResult)obj;
            this.removePrefix(result.getChangeInfo());
            this.removePrefix(result.getHostedZone());
            this.removePrefix(result.getDelegationSet());
        } else if (obj instanceof DeleteHostedZoneResult) {
            DeleteHostedZoneResult result = (DeleteHostedZoneResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof GetChangeResult) {
            GetChangeResult result = (GetChangeResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof GetHostedZoneResult) {
            GetHostedZoneResult result = (GetHostedZoneResult)obj;
            this.removePrefix(result.getHostedZone());
        } else if (obj instanceof ListHostedZonesResult) {
            ListHostedZonesResult result = (ListHostedZonesResult)obj;
            for (HostedZone zone : result.getHostedZones()) {
                this.removePrefix(zone);
            }
        } else if (obj instanceof ListResourceRecordSetsResult) {
            ListResourceRecordSetsResult result = (ListResourceRecordSetsResult)obj;
            for (ResourceRecordSet rrset : result.getResourceRecordSets()) {
                this.removePrefix(rrset);
            }
        } else if (obj instanceof CreateHealthCheckResult) {
            CreateHealthCheckResult result = (CreateHealthCheckResult)obj;
            this.removePrefix(result.getHealthCheck());
        } else if (obj instanceof GetHealthCheckResult) {
            GetHealthCheckResult result = (GetHealthCheckResult)obj;
            this.removePrefix(result.getHealthCheck());
        } else if (obj instanceof ListHealthChecksResult) {
            ListHealthChecksResult result = (ListHealthChecksResult)obj;
            for (HealthCheck check : result.getHealthChecks()) {
                this.removePrefix(check);
            }
        } else if (obj instanceof CreateReusableDelegationSetResult) {
            CreateReusableDelegationSetResult result = (CreateReusableDelegationSetResult)obj;
            this.removePrefix(result.getDelegationSet());
        } else if (obj instanceof GetReusableDelegationSetResult) {
            GetReusableDelegationSetResult result = (GetReusableDelegationSetResult)obj;
            this.removePrefix(result.getDelegationSet());
        } else if (obj instanceof ListReusableDelegationSetsResult) {
            ListReusableDelegationSetsResult result = (ListReusableDelegationSetsResult)obj;
            for (DelegationSet delegationSet : result.getDelegationSets()) {
                this.removePrefix(delegationSet);
            }
        } else if (obj instanceof CreateKeySigningKeyResult) {
            CreateKeySigningKeyResult result = (CreateKeySigningKeyResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof DeleteKeySigningKeyResult) {
            DeleteKeySigningKeyResult result = (DeleteKeySigningKeyResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof ActivateKeySigningKeyResult) {
            ActivateKeySigningKeyResult result = (ActivateKeySigningKeyResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof DeactivateKeySigningKeyResult) {
            DeactivateKeySigningKeyResult result = (DeactivateKeySigningKeyResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof EnableHostedZoneDNSSECResult) {
            EnableHostedZoneDNSSECResult result = (EnableHostedZoneDNSSECResult)obj;
            this.removePrefix(result.getChangeInfo());
        } else if (obj instanceof DisableHostedZoneDNSSECResult) {
            DisableHostedZoneDNSSECResult result = (DisableHostedZoneDNSSECResult)obj;
            this.removePrefix(result.getChangeInfo());
        }
    }

    private void removePrefix(ResourceRecordSet rrset) {
        if (rrset == null) {
            return;
        }
        this.removePrefix(rrset.getAliasTarget());
        rrset.setHealthCheckId(this.removePrefix(rrset.getHealthCheckId()));
    }

    private void removePrefix(AliasTarget aliasTarget) {
        if (aliasTarget == null) {
            return;
        }
        aliasTarget.setHostedZoneId(this.removePrefix(aliasTarget.getHostedZoneId()));
    }

    private void removePrefix(ChangeInfo changeInfo) {
        if (changeInfo == null) {
            return;
        }
        if (changeInfo.getId() != null) {
            changeInfo.setId(this.removePrefix(changeInfo.getId()));
        }
    }

    private void removePrefix(HostedZone hostedZone) {
        if (hostedZone == null) {
            return;
        }
        if (hostedZone.getId() != null) {
            hostedZone.setId(this.removePrefix(hostedZone.getId()));
        }
    }

    private void removePrefix(HealthCheck healthCheck) {
        if (healthCheck == null) {
            return;
        }
        if (healthCheck.getId() != null) {
            healthCheck.setId(this.removePrefix(healthCheck.getId()));
        }
    }

    private void removePrefix(DelegationSet delegationSet) {
        if (delegationSet == null) {
            return;
        }
        if (delegationSet.getId() != null) {
            delegationSet.setId(this.removePrefix(delegationSet.getId()));
        }
    }

    private String removePrefix(String s) {
        if (s == null) {
            return null;
        }
        int lastIndex = s.lastIndexOf("/");
        if (lastIndex > 0) {
            return s.substring(lastIndex + 1);
        }
        return s;
    }
}

