/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.MetricData;
import java.util.Date;

@SdkInternalApi
public class MetricDataMarshaller {
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<Float> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MetricDataMarshaller instance = new MetricDataMarshaller();

    public static MetricDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricData metricData, ProtocolMarshaller protocolMarshaller) {
        if (metricData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(metricData.getMetricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall(metricData.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall(metricData.getTimestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

