/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.helpers;

import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.Logger;
import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.util.Unbox;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFRow;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.logging.PoiLogManager;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.FormulaParseException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.FormulaParser;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.FormulaRenderer;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.FormulaShifter;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.FormulaType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.ptg.Ptg;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Cell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Row;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Sheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.Internal;

@Internal
final class HSSFRowColShifter {
    private static final Logger LOG = PoiLogManager.getLogger(HSSFRowColShifter.class);

    private HSSFRowColShifter() {
    }

    static void updateFormulas(Sheet sheet, FormulaShifter formulaShifter) {
        HSSFRowColShifter.updateSheetFormulas(sheet, formulaShifter);
        Workbook wb = sheet.getWorkbook();
        for (Sheet sh : wb) {
            if (sheet == sh) continue;
            HSSFRowColShifter.updateSheetFormulas(sh, formulaShifter);
        }
    }

    static void updateSheetFormulas(Sheet sh, FormulaShifter formulashifter) {
        for (Row r : sh) {
            HSSFRow row = (HSSFRow)r;
            HSSFRowColShifter.updateRowFormulas(row, formulashifter);
        }
    }

    static void updateRowFormulas(HSSFRow row, FormulaShifter formulaShifter) {
        HSSFSheet sheet = row.getSheet();
        for (Cell c : row) {
            HSSFCell cell = (HSSFCell)c;
            String formula = cell.getCellFormula();
            if (formula.length() <= 0) continue;
            String shiftedFormula = HSSFRowColShifter.shiftFormula(row, formula, formulaShifter);
            cell.setCellFormula(shiftedFormula);
        }
    }

    static String shiftFormula(Row row, String formula, FormulaShifter formulaShifter) {
        Sheet sheet = row.getSheet();
        Workbook wb = sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(sheet);
        int rowIndex = row.getRowNum();
        HSSFEvaluationWorkbook fpb = HSSFEvaluationWorkbook.create((HSSFWorkbook)wb);
        try {
            Ptg[] ptgs = FormulaParser.parse(formula, fpb, FormulaType.CELL, sheetIndex, rowIndex);
            String shiftedFmla = formulaShifter.adjustFormula(ptgs, sheetIndex) ? FormulaRenderer.toFormulaString(fpb, ptgs) : formula;
            return shiftedFmla;
        }
        catch (FormulaParseException fpe) {
            LOG.atWarn().withThrowable(fpe).log("Error shifting formula on row {}", (Object)Unbox.box(row.getRowNum()));
            return formula;
        }
    }
}

