/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ooxml.POIXMLDocument;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ooxml.POIXMLDocumentPart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ooxml.POIXMLException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ooxml.util.PackageHelper;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.OPCPackage;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.PackagePart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFDocument;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFMasters;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFPage;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFPages;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFStyleSheet;
import com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.XmlException;
import com.microsoft.schemas.office.visio.x2012.main.VisioDocumentDocument1;
import com.microsoft.schemas.office.visio.x2012.main.VisioDocumentType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class XmlVisioDocument
extends POIXMLDocument {
    protected XDGFPages _pages;
    protected XDGFMasters _masters;
    protected XDGFDocument _document;

    public XmlVisioDocument(OPCPackage pkg) throws IOException {
        super(pkg, "http://schemas.microsoft.com/visio/2010/relationships/document");
        VisioDocumentType document;
        try (InputStream stream = this.getPackagePart().getInputStream();){
            document = ((VisioDocumentDocument1)VisioDocumentDocument1.Factory.parse(stream)).getVisioDocument();
        }
        catch (XmlException | IOException e) {
            throw new POIXMLException(e);
        }
        this._document = new XDGFDocument(document);
        this.load(new XDGFFactory(this._document));
    }

    public XmlVisioDocument(InputStream stream) throws IOException {
        this(stream, true);
    }

    public XmlVisioDocument(InputStream stream, boolean closeStream) throws IOException {
        this(PackageHelper.open(stream, closeStream));
    }

    @Override
    protected void onDocumentRead() {
        for (POIXMLDocumentPart part : this.getRelations()) {
            if (part instanceof XDGFPages) {
                this._pages = (XDGFPages)part;
                continue;
            }
            if (!(part instanceof XDGFMasters)) continue;
            this._masters = (XDGFMasters)part;
        }
        if (this._masters != null) {
            this._masters.onDocumentRead();
        }
        if (this._pages != null) {
            this._pages.onDocumentRead();
        }
    }

    @Override
    public List<PackagePart> getAllEmbeddedParts() {
        return new ArrayList<PackagePart>();
    }

    public Collection<XDGFPage> getPages() {
        if (this._pages == null) {
            throw new IllegalStateException("No page-information available");
        }
        return this._pages.getPageList();
    }

    public XDGFStyleSheet getStyleById(long id) {
        return this._document.getStyleById(id);
    }
}

