/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.thrift.transport.sasl;

import com.databricks.client.jdbc42.internal.apache.thrift.transport.sasl.FixedSizeHeaderReader;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.sasl.NegotiationStatus;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.sasl.TSaslNegotiationException;

public class SaslNegotiationHeaderReader
extends FixedSizeHeaderReader {
    public static final int STATUS_BYTES = 1;
    public static final int PAYLOAD_LENGTH_BYTES = 4;
    private NegotiationStatus negotiationStatus;
    private int payloadSize;

    @Override
    protected int headerSize() {
        return 5;
    }

    @Override
    protected void onComplete() throws TSaslNegotiationException {
        this.negotiationStatus = NegotiationStatus.byValue(this.byteBuffer.get(0));
        this.payloadSize = this.byteBuffer.getInt(1);
        if (this.payloadSize < 0) {
            throw new TSaslNegotiationException(TSaslNegotiationException.ErrorType.PROTOCOL_ERROR, "Payload size is negative: " + this.payloadSize);
        }
    }

    @Override
    public int payloadSize() {
        return this.payloadSize;
    }

    public NegotiationStatus getStatus() {
        return this.negotiationStatus;
    }
}

