/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.jdbc;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.HiveExecutionContext;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TRowSet;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowBatch;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkDirectResults;
import com.databricks.client.spark.arrow.ArrowBuffer;
import com.databricks.client.spark.jdbc.ResultFileDownloadHandler;
import com.databricks.client.spark.jdbc.UCVolumeIngestionManager;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class DownloadableExecutionContext
extends HiveExecutionContext {
    public ArrayList<ResultFileDownloadHandler> m_resultFileDownloadHandlers;
    public int m_numConsecutiveResultFileDownloadRetries = 0;
    public long m_downloadedResultFilesSize;
    public boolean m_downloadNeedRetry = false;
    public static final int STAGING_OPERATION_INDEX = 0;
    public static final String STAGING_OPERATION_REMOVE = "REMOVE";

    public DownloadableExecutionContext(HiveJDBCSettings hiveJDBCSettings) {
        super(hiveJDBCSettings);
        if (hiveJDBCSettings.m_proxySettings.m_InvalidPortProxyCloudFetch.booleanValue()) {
            hiveJDBCSettings.m_proxySettings.m_proxyPort = -1;
        }
        this.m_resultFileDownloadHandlers = new ArrayList();
    }

    @Override
    protected void handleDirectResultsResp(ILogger iLogger, TSparkDirectResults tSparkDirectResults) throws ErrorException {
        boolean bl;
        super.handleDirectResultsResp(iLogger, tSparkDirectResults);
        if (tSparkDirectResults.getResultSetMetadata() != null && (bl = tSparkDirectResults.getResultSetMetadata().isIsStagingOperation()) && this.m_settings.m_useNativeQuery) {
            TRowSet tRowSet = tSparkDirectResults.getResultSet().getResults();
            if (tRowSet == null) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), new String(" Direct Result returned the null row."));
                throw errorException;
            }
            TSparkArrowBatch tSparkArrowBatch = tRowSet.getArrowBatches().get(0);
            ArrowBuffer arrowBuffer = new ArrowBuffer(iLogger, tSparkDirectResults.getResultSetMetadata().getSchema().getColumns(), tSparkDirectResults.getResultSetMetadata().isLz4Compressed(), this.m_settings);
            arrowBuffer.deserializeBatch(tSparkArrowBatch);
            List<String> list = arrowBuffer.getUCVolIngestionOpDetails();
            UCVolumeIngestionManager uCVolumeIngestionManager = new UCVolumeIngestionManager(iLogger, this.m_settings);
            String string = list.get(0);
            if (!(this.m_settings.m_stagingAllowedLocalPaths != null && this.m_settings.m_stagingAllowedLocalPaths.size() != 0 || string.equalsIgnoreCase(STAGING_OPERATION_REMOVE))) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INVALID_STAGING_ALLOWED_LOCAL_PATHS_UC_INGESTION.name());
                throw errorException;
            }
            if (list.size() >= 3) {
                uCVolumeIngestionManager.performOperations(list);
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GENERAL_ERROR_UC_INGESTION.name(), new String("Staging operation details are not sufficient to send the HTTP request ."));
                throw errorException;
            }
        }
    }
}

