/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.Warning;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;

public class ETUCaseFn
extends ETScalarFn {
    public ETUCaseFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (iColumn.getTypeMetadata().isCharacterType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        boolean bl = this.hasMoreData(0);
        long l = eTDataRequest.getOffset() / 2L;
        long l2 = this.getResultMetadata().getColumnLength();
        if (l + (long)string.length() > l2) {
            bl = false;
            int n = (int)(l2 - l);
            string = string.substring(0, n);
            IWarningListener iWarningListener = this.getWarningListener();
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1L, -1));
        }
        eTDataRequest.getData().setChar(string.toUpperCase());
        return bl;
    }
}

