/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.support.conv;

import com.databricks.client.support.conv.ConversionResult;
import com.databricks.client.support.conv.ConverterConstants;
import com.databricks.client.support.conv.ExactNumConverter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntegralConverter {
    private IntegralConverter() {
    }

    public static String bitToChar(boolean bl, long l, ConversionResult conversionResult) {
        return IntegralConverter.toChar(bl ? 1 : 0, l, conversionResult);
    }

    public static String booleanToChar(boolean bl, long l, ConversionResult conversionResult) {
        String string = String.valueOf(bl);
        if ((long)string.length() <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l);
        }
        return string;
    }

    public static boolean toBit(long l, ConversionResult conversionResult) {
        if (0L == l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        if (1L == l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if (l < 0L) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return false;
        }
        conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        return false;
    }

    public static boolean toBit(BigInteger bigInteger, ConversionResult conversionResult) {
        if (BigInteger.ZERO.equals(bigInteger)) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        if (BigInteger.ONE.equals(bigInteger)) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return false;
        }
        conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        return false;
    }

    public static BigDecimal toBigDecimal(long l, short s, short s2, ConversionResult conversionResult) {
        return ExactNumConverter.setPrecScale(new BigDecimal(l), s, s2, conversionResult);
    }

    public static BigDecimal toBigDecimal(BigInteger bigInteger, short s, short s2, ConversionResult conversionResult) {
        return ExactNumConverter.setPrecScale(new BigDecimal(bigInteger), s, s2, conversionResult);
    }

    public static BigDecimal toBigDecimal(boolean bl, short s, short s2, ConversionResult conversionResult) {
        if (s < 1 || s2 > s || s2 < 0) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        if (!bl) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return BigDecimal.ZERO;
        }
        if (s == s2) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        return BigDecimal.ONE;
    }

    public static String toChar(BigInteger bigInteger, long l, ConversionResult conversionResult) {
        String string = bigInteger.toString();
        if ((long)string.length() <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l);
        }
        return string;
    }

    public static String toChar(long l, long l2, ConversionResult conversionResult) {
        String string = String.valueOf(l);
        if ((long)string.length() <= l2) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l2);
        }
        return string;
    }

    public static BigInteger toBigInt(long l, boolean bl, ConversionResult conversionResult) {
        if (!bl && 0L > l) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        return BigInteger.valueOf(l);
    }

    public static BigInteger toBigInt(BigInteger bigInteger, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (bl) {
            bigInteger3 = ConverterConstants.SIGNED_BIGINT_MIN;
            bigInteger2 = ConverterConstants.SIGNED_BIGINT_MAX;
        } else {
            bigInteger3 = BigInteger.ZERO;
            bigInteger2 = ConverterConstants.UNSIGNED_BIGINT_MAX;
        }
        IntegralConverter.checkRange(bigInteger, bigInteger3, bigInteger2, conversionResult);
        return bigInteger;
    }

    public static double toDouble(BigInteger bigInteger, ConversionResult conversionResult) {
        int n = bigInteger.compareTo(ConverterConstants.MAX_INTEGRAL_IN_DOUBLE_INVARIANT);
        int n2 = bigInteger.compareTo(ConverterConstants.MIN_INTEGRAL_IN_DOUBLE_INVARIANT);
        if (n <= 0 && n2 >= 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return bigInteger.longValue();
        }
        double d = bigInteger.doubleValue();
        IntegralConverter.checkIntegralToDoubleExact(bigInteger, d, conversionResult);
        return d;
    }

    public static float toFloat(BigInteger bigInteger, ConversionResult conversionResult) {
        int n = bigInteger.compareTo(ConverterConstants.MAX_INTEGRAL_IN_FLOAT_INVARIANT);
        int n2 = bigInteger.compareTo(ConverterConstants.MIN_INTEGRAL_IN_FLOAT_INVARIANT);
        if (n <= 0 && n2 >= 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return bigInteger.longValue();
        }
        float f = (float)bigInteger.doubleValue();
        IntegralConverter.checkIntegralToFloatExact(bigInteger, f, conversionResult);
        return f;
    }

    public static float toFloat(long l, ConversionResult conversionResult) {
        float f = l;
        if (l <= ConverterConstants.MAX_INTEGRAL_IN_FLOAT_INVARIANT.longValue() || l >= ConverterConstants.MIN_INTEGRAL_IN_FLOAT_INVARIANT.longValue()) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            IntegralConverter.checkIntegralToFloatExact(BigInteger.valueOf(l), f, conversionResult);
        }
        return f;
    }

    public static long toInteger(long l, boolean bl, ConversionResult conversionResult) {
        long l2;
        long l3;
        if (bl) {
            l3 = Integer.MIN_VALUE;
            l2 = Integer.MAX_VALUE;
        } else {
            l3 = 0L;
            l2 = 0xFFFFFFFFL;
        }
        IntegralConverter.checkRange(l, l3, l2, conversionResult);
        return l;
    }

    public static long toInteger(BigInteger bigInteger, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (bl) {
            bigInteger3 = ConverterConstants.SIGNED_INT_MIN;
            bigInteger2 = ConverterConstants.SIGNED_INT_MAX;
        } else {
            bigInteger3 = BigInteger.ZERO;
            bigInteger2 = ConverterConstants.UNSIGNED_INT_MAX;
        }
        IntegralConverter.checkRange(bigInteger, bigInteger3, bigInteger2, conversionResult);
        return bigInteger.longValue();
    }

    public static int toSmallInt(long l, boolean bl, ConversionResult conversionResult) {
        long l2;
        long l3;
        if (bl) {
            l3 = -32768L;
            l2 = 32767L;
        } else {
            l3 = 0L;
            l2 = 65535L;
        }
        IntegralConverter.checkRange(l, l3, l2, conversionResult);
        return (int)l;
    }

    public static int toSmallInt(BigInteger bigInteger, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (bl) {
            bigInteger3 = ConverterConstants.SIGNED_SMALLINT_MIN;
            bigInteger2 = ConverterConstants.SIGNED_SMALLINT_MAX;
        } else {
            bigInteger3 = BigInteger.ZERO;
            bigInteger2 = ConverterConstants.UNSIGNED_SMALLINT_MAX;
        }
        IntegralConverter.checkRange(bigInteger, bigInteger3, bigInteger2, conversionResult);
        return bigInteger.intValue();
    }

    public static short toTinyInt(long l, boolean bl, ConversionResult conversionResult) {
        long l2;
        long l3;
        if (bl) {
            l3 = -128L;
            l2 = 127L;
        } else {
            l3 = 0L;
            l2 = 255L;
        }
        IntegralConverter.checkRange(l, l3, l2, conversionResult);
        return (short)l;
    }

    public static short toTinyInt(BigInteger bigInteger, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (bl) {
            bigInteger3 = ConverterConstants.SIGNED_TINYINT_MIN;
            bigInteger2 = ConverterConstants.SIGNED_TINYINT_MAX;
        } else {
            bigInteger3 = BigInteger.ZERO;
            bigInteger2 = ConverterConstants.UNSIGNED_TINYINT_MAX;
        }
        IntegralConverter.checkRange(bigInteger, bigInteger3, bigInteger2, conversionResult);
        return bigInteger.shortValue();
    }

    private static void checkIntegralToDoubleExact(BigInteger bigInteger, double d, ConversionResult conversionResult) {
        BigDecimal bigDecimal = new BigDecimal(d);
        if (bigInteger.equals(bigDecimal.toBigInteger())) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.INTEGRAL_PRECISION_LOSS);
        }
    }

    private static void checkIntegralToFloatExact(BigInteger bigInteger, float f, ConversionResult conversionResult) {
        BigDecimal bigDecimal = new BigDecimal(f);
        if (bigInteger.equals(bigDecimal.toBigInteger())) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.INTEGRAL_PRECISION_LOSS);
        }
    }

    private static void checkRange(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, ConversionResult conversionResult) {
        assert (bigInteger3.compareTo(bigInteger2) >= 0);
        if (bigInteger.compareTo(bigInteger2) < 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else if (bigInteger.compareTo(bigInteger3) > 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
    }

    private static void checkRange(long l, long l2, long l3, ConversionResult conversionResult) {
        assert (l3 >= l2);
        if (l < l2) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else if (l > l3) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
    }
}

