/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.kernel.protocol.v5.handler;

import java.io.Serializable;
import org.apache.toree.comm.CommCallbacks;
import org.apache.toree.comm.CommRegistrar;
import org.apache.toree.comm.CommStorage;
import org.apache.toree.comm.KernelCommWriter;
import org.apache.toree.global.ExecuteRequestState$;
import org.apache.toree.kernel.protocol.v5.KMBuilder;
import org.apache.toree.kernel.protocol.v5.KMBuilder$;
import org.apache.toree.kernel.protocol.v5.KernelMessage;
import org.apache.toree.kernel.protocol.v5.content.CommOpen;
import org.apache.toree.kernel.protocol.v5.content.CommOpen$;
import org.apache.toree.kernel.protocol.v5.handler.BaseHandler;
import org.apache.toree.kernel.protocol.v5.kernel.ActorLoader;
import org.apache.toree.kernel.protocol.v5.kernel.Utilities$;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0005\n\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0003;\u0001\u0011\u00053\bC\u0003X\u0001\u0011%\u0001\fC\u0003k\u0001\u0011%1NA\bD_6lw\n]3o\u0011\u0006tG\r\\3s\u0015\tQ1\"A\u0004iC:$G.\u001a:\u000b\u00051i\u0011A\u0001<6\u0015\tqq\"\u0001\u0005qe>$xnY8m\u0015\t\u0001\u0012#\u0001\u0004lKJtW\r\u001c\u0006\u0003%M\tQ\u0001^8sK\u0016T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001a;A\u0011!dG\u0007\u0002\u0013%\u0011A$\u0003\u0002\f\u0005\u0006\u001cX\rS1oI2,'\u000f\u0005\u0002\u001fC5\tqD\u0003\u0002!#\u0005)Q\u000f^5mg&\u0011!e\b\u0002\u0012\u001b\u0016\u001c8/Y4f\u0019><7+\u001e9q_J$\u0018aC1di>\u0014Hj\\1eKJ\u0004\"!J\u0014\u000e\u0003\u0019R!\u0001E\u0006\n\u0005!2#aC!di>\u0014Hj\\1eKJ\fQbY8n[J+w-[:ue\u0006\u0014\bCA\u0016/\u001b\u0005a#BA\u0017\u0012\u0003\u0011\u0019w.\\7\n\u0005=b#!D\"p[6\u0014VmZ5tiJ\f'/A\u0006d_6l7\u000b^8sC\u001e,\u0007CA\u00163\u0013\t\u0019DFA\u0006D_6l7\u000b^8sC\u001e,\u0017A\u0002\u001fj]&$h\b\u0006\u00037oaJ\u0004C\u0001\u000e\u0001\u0011\u0015\u0019C\u00011\u0001%\u0011\u0015IC\u00011\u0001+\u0011\u0015\u0001D\u00011\u00012\u0003\u001d\u0001(o\\2fgN$\"\u0001P)1\u0005u:\u0005c\u0001 D\u000b6\tqH\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R \u0003\r\u0019+H/\u001e:f!\t1u\t\u0004\u0001\u0005\u0013!+\u0011\u0011!A\u0001\u0006\u0003I%aA0%cE\u0011!J\u0014\t\u0003\u00172k\u0011!Q\u0005\u0003\u001b\u0006\u0013qAT8uQ&tw\r\u0005\u0002L\u001f&\u0011\u0001+\u0011\u0002\u0004\u0003:L\b\"\u0002*\u0006\u0001\u0004\u0019\u0016!D6fe:,G.T3tg\u0006<W\r\u0005\u0002U+6\t1\"\u0003\u0002W\u0017\ti1*\u001a:oK2lUm]:bO\u0016\fa\u0002[1oI2,7i\\7n\u001fB,g\u000e\u0006\u0002ZKR\u0011!,\u0018\t\u0003\u0017nK!\u0001X!\u0003\tUs\u0017\u000e\u001e\u0005\u0006=\u001a\u0001\raX\u0001\tG>lWn\u00149f]B\u0011\u0001mY\u0007\u0002C*\u0011!mC\u0001\bG>tG/\u001a8u\u0013\t!\u0017M\u0001\u0005D_6lw\n]3o\u0011\u00151g\u00011\u0001h\u0003%YWNQ;jY\u0012,'\u000f\u0005\u0002UQ&\u0011\u0011n\u0003\u0002\n\u00176\u0013U/\u001b7eKJ\f\u0001\u0003[1oI2,\u0007+\u0019:tK\u0016\u0013(o\u001c:\u0015\u0005ic\u0007\"B7\b\u0001\u0004q\u0017aB5om\u0006d\u0017\u000e\u001a\t\u0004_^ThB\u00019v\u001d\t\tH/D\u0001s\u0015\t\u0019x#\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011a/Q\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0018PA\u0002TKFT!A^!\u0011\u000b-[X0a\u0005\n\u0005q\f%A\u0002+va2,'\u0007E\u0002\u007f\u0003\u001fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003kg>t'\u0002BA\u0003\u0003\u000f\tA\u0001\\5cg*!\u0011\u0011BA\u0006\u0003\r\t\u0007/\u001b\u0006\u0003\u0003\u001b\tA\u0001\u001d7bs&\u0019\u0011\u0011C@\u0003\r)\u001b\b+\u0019;i!\u0011yw/!\u0006\u0011\u0007y\f9\"C\u0002\u0002\u001a}\u00141CS:p]Z\u000bG.\u001b3bi&|g.\u0012:s_J\u0004")
public class CommOpenHandler
extends BaseHandler {
    private final ActorLoader actorLoader;
    private final CommStorage commStorage;

    @Override
    public Future<?> process(KernelMessage kernelMessage) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logKernelMessageAction("Initiating Comm Open for", kernelMessage);
            ExecuteRequestState$.MODULE$.processIncomingKernelMessage(kernelMessage);
            KMBuilder kmBuilder = new KMBuilder(KMBuilder$.MODULE$.apply$default$1()).withParent(kernelMessage);
            Utilities$.MODULE$.parseAndHandle(kernelMessage.contentString(), CommOpen$.MODULE$.commOpenReads(), (Function1 & Serializable & scala.Serializable)commOpen -> {
                this.handleCommOpen(kmBuilder, commOpen);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)invalid -> {
                this.handleParseError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)invalid);
                return BoxedUnit.UNIT;
            });
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private void handleCommOpen(KMBuilder kmBuilder, CommOpen commOpen) {
        String commId = commOpen.comm_id();
        String targetName = commOpen.target_name();
        JsValue data = commOpen.data();
        this.logger().debug(new StringBuilder(43).append("Received comm_open for target '").append(targetName).append("' with id '").append(commId).append("'").toString());
        KernelCommWriter commWriter = new KernelCommWriter(this.actorLoader, kmBuilder, commId);
        Option<CommCallbacks> option2 = this.commStorage.getTargetCallbacks(targetName);
        if (None$.MODULE$.equals(option2)) {
            this.logger().warn(new StringBuilder(39).append("Received invalid target for Comm Open: ").append(targetName).toString());
            commWriter.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            CommCallbacks callbacks = (CommCallbacks)some.value();
            this.logger().debug(new StringBuilder(34).append("Executing open callbacks for id '").append(commId).append("'").toString());
            ((IterableLike)((TraversableLike)callbacks.executeOpenCallbacks(commWriter, commId, targetName, data).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.failed(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)throwable2 -> {
                CommOpenHandler.$anonfun$handleCommOpen$3(this, throwable2);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    private void handleParseError(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> invalid) {
        this.logger().warn("Parse error for Comm Open! Not responding!");
    }

    public static final /* synthetic */ void $anonfun$handleCommOpen$3(CommOpenHandler $this, Try throwable2) {
        $this.logger().error("Comm open callback encountered an error!", new Object[]{throwable2});
    }

    public CommOpenHandler(ActorLoader actorLoader, CommRegistrar commRegistrar, CommStorage commStorage) {
        this.actorLoader = actorLoader;
        this.commStorage = commStorage;
        super(actorLoader);
    }
}

