/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.style.Description;
import org.opengis.util.Cloneable;

public class StyleImpl
implements Style,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger(StyleImpl.class);
    private List<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
    private DescriptionImpl description = new DescriptionImpl();
    private String name = "Default Styler";
    private boolean defaultB = false;
    private Fill background;
    private Symbolizer defaultSymbolizer;

    protected StyleImpl() {
    }

    @Override
    public DescriptionImpl getDescription() {
        return this.description;
    }

    public FeatureTypeStyle[] getFeatureTypeStyles() {
        FeatureTypeStyle[] ret = new FeatureTypeStyle[]{new FeatureTypeStyleImpl()};
        if (this.featureTypeStyles != null && !this.featureTypeStyles.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("number of fts set " + this.featureTypeStyles.size());
            }
            ret = this.featureTypeStyles.toArray(new FeatureTypeStyle[0]);
        }
        return ret;
    }

    @Override
    public List<FeatureTypeStyle> featureTypeStyles() {
        return this.featureTypeStyles;
    }

    @Override
    public Symbolizer getDefaultSpecification() {
        return this.defaultSymbolizer;
    }

    @Override
    public void setDefaultSpecification(Symbolizer defaultSymbolizer) {
        this.defaultSymbolizer = defaultSymbolizer;
    }

    public void setFeatureTypeStyles(FeatureTypeStyle ... styles) {
        List<FeatureTypeStyle> newStyles = Arrays.asList(styles);
        this.featureTypeStyles.clear();
        this.featureTypeStyles.addAll(newStyles);
        LOGGER.fine("StyleImpl added " + this.featureTypeStyles.size() + " feature types");
    }

    public void addFeatureTypeStyle(FeatureTypeStyle type) {
        this.featureTypeStyles.add(type);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.defaultB;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.defaultB = isDefault;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Style clone;
        try {
            clone = (Style)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        ArrayList<FeatureTypeStyle> ftsCopies = new ArrayList<FeatureTypeStyle>();
        for (FeatureTypeStyle featureTypeStyle : this.featureTypeStyles) {
            ftsCopies.add((FeatureTypeStyle)((Cloneable)featureTypeStyle).clone());
        }
        clone.featureTypeStyles().clear();
        clone.featureTypeStyles().addAll(ftsCopies);
        return clone;
    }

    public int hashCode() {
        return Objects.hash(this.featureTypeStyles, this.description, this.name, this.defaultB, this.background, this.defaultSymbolizer);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof StyleImpl) {
            StyleImpl other = (StyleImpl)oth;
            return Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.description, (Object)other.description) && Utilities.equals(this.featureTypeStyles, other.featureTypeStyles) && Utilities.equals((Object)this.background, (Object)other.background);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StyleImpl");
        buf.append("[");
        if (this.name != null) {
            buf.append(" name=");
            buf.append(this.name);
        } else {
            buf.append(" UNNAMED");
        }
        if (this.defaultB) {
            buf.append(", DEFAULT");
        }
        buf.append("]");
        return buf.toString();
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object extraData) {
        return visitor.visit((org.opengis.style.Style)this, extraData);
    }

    public void setDescription(Description description) {
        this.description = description == null ? new DescriptionImpl() : DescriptionImpl.cast(description);
    }

    @Override
    public Fill getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Fill background) {
        this.background = background;
    }
}

