/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Date;
import org.geotools.temporal.object.DefaultTemporalObject;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.TemporalOrder;
import org.opengis.temporal.TemporalPrimitive;

public abstract class DefaultTemporalPrimitive
extends DefaultTemporalObject
implements TemporalPrimitive,
TemporalOrder,
Comparable<TemporalPrimitive> {
    @Override
    public int compareTo(TemporalPrimitive that) {
        if (that == null) {
            throw new IllegalArgumentException("Provided temporal object is null");
        }
        RelativePosition pos = this.relativePosition(that);
        if (pos == null) {
            throw new ClassCastException("The provided object cannot be compared to this one");
        }
        if (pos == RelativePosition.BEFORE) {
            return -1;
        }
        if (pos == RelativePosition.AFTER) {
            return 1;
        }
        if (pos == RelativePosition.EQUALS) {
            return 0;
        }
        if ((this instanceof Period && that instanceof Instant || this instanceof Instant && that instanceof Period) && (pos == RelativePosition.ENDED_BY || pos == RelativePosition.BEGUN_BY || pos == RelativePosition.CONTAINS)) {
            return 0;
        }
        if (this instanceof Period && that instanceof Period) {
            if (pos == RelativePosition.MEETS) {
                return -1;
            }
            if (pos == RelativePosition.BEGINS) {
                return -1;
            }
            if (pos == RelativePosition.BEGUN_BY) {
                return 1;
            }
            if (pos == RelativePosition.ENDS) {
                return 1;
            }
            if (pos == RelativePosition.ENDED_BY) {
                return -1;
            }
            if (pos == RelativePosition.OVERLAPS) {
                return -1;
            }
            if (pos == RelativePosition.OVERLAPPED_BY) {
                return 1;
            }
            if (pos == RelativePosition.DURING || pos == RelativePosition.CONTAINS || pos == RelativePosition.EQUALS) {
                return 0;
            }
        }
        throw new IllegalStateException("Unable to compare the provided object with this one");
    }

    public RelativePosition relativePosition(TemporalPrimitive other) {
        if (this instanceof Instant && other instanceof Instant) {
            Instant thisInstant = (Instant)this;
            Instant otherIstant = (Instant)other;
            return this.relativePosition(thisInstant, otherIstant);
        }
        if (this instanceof Period && other instanceof Instant) {
            Period thisPeriod = (Period)this;
            Instant otherInstant = (Instant)other;
            return this.relativePosition(thisPeriod, otherInstant);
        }
        if (this instanceof Instant && other instanceof Period) {
            Instant thisIstant = (Instant)this;
            Period otherPeriod = (Period)other;
            return this.relativePosition(thisIstant, otherPeriod);
        }
        if (this instanceof Period && other instanceof Period) {
            Period thisPeriod = (Period)this;
            Period otherPeriod = (Period)other;
            return this.relativePosition(thisPeriod, otherPeriod);
        }
        return null;
    }

    private RelativePosition relativePosition(Period thisPeriod, Period otherPeriod) {
        Date thisBeginning = thisPeriod.getBeginning().getPosition().getDate();
        Date thisEnding = thisPeriod.getEnding().getPosition().getDate();
        Date otherBeginning = otherPeriod.getBeginning().getPosition().getDate();
        Date otherEnding = otherPeriod.getEnding().getPosition().getDate();
        if (thisEnding.before(otherBeginning)) {
            return RelativePosition.BEFORE;
        }
        if (thisEnding.compareTo(otherBeginning) == 0) {
            return RelativePosition.MEETS;
        }
        if (thisBeginning.before(otherBeginning) && thisEnding.after(otherBeginning) && thisEnding.before(otherEnding)) {
            return RelativePosition.OVERLAPS;
        }
        if (thisBeginning.compareTo(otherBeginning) == 0 && thisEnding.before(otherEnding)) {
            return RelativePosition.BEGINS;
        }
        if (thisBeginning.compareTo(otherBeginning) == 0 && thisEnding.after(otherEnding)) {
            return RelativePosition.BEGUN_BY;
        }
        if (thisBeginning.after(otherBeginning) && thisEnding.before(otherEnding)) {
            return RelativePosition.DURING;
        }
        if (thisBeginning.before(otherBeginning) && thisEnding.after(otherEnding)) {
            return RelativePosition.CONTAINS;
        }
        if (thisBeginning.compareTo(otherBeginning) == 0 && thisEnding.compareTo(otherEnding) == 0) {
            return RelativePosition.EQUALS;
        }
        if (thisBeginning.after(otherBeginning) && thisBeginning.before(otherEnding) && thisEnding.after(otherEnding)) {
            return RelativePosition.OVERLAPPED_BY;
        }
        if (thisBeginning.after(otherBeginning) && thisEnding.compareTo(otherEnding) == 0) {
            return RelativePosition.ENDS;
        }
        if (thisBeginning.before(otherBeginning) && thisEnding.compareTo(otherEnding) == 0) {
            return RelativePosition.ENDED_BY;
        }
        return thisBeginning.compareTo(otherEnding) == 0 ? RelativePosition.MET_BY : RelativePosition.AFTER;
    }

    private RelativePosition relativePosition(Instant thisInstant, Period otherPeriod) {
        Date thisDate;
        Date otherEnd = otherPeriod.getEnding().getPosition().getDate();
        if (otherEnd.before(thisDate = thisInstant.getPosition().getDate())) {
            return RelativePosition.AFTER;
        }
        if (otherEnd.compareTo(thisDate) == 0) {
            return RelativePosition.ENDS;
        }
        Date otherBeginning = otherPeriod.getBeginning().getPosition().getDate();
        if (otherBeginning.before(thisDate) && otherEnd.after(thisDate)) {
            return RelativePosition.DURING;
        }
        return otherBeginning.compareTo(thisDate) == 0 ? RelativePosition.BEGINS : RelativePosition.BEFORE;
    }

    private RelativePosition relativePosition(Period thisPeriod, Instant otherInstant) {
        Date otherDate;
        Date thisEnd = thisPeriod.getEnding().getPosition().getDate();
        if (thisEnd.before(otherDate = otherInstant.getPosition().getDate())) {
            return RelativePosition.BEFORE;
        }
        if (thisEnd.compareTo(otherDate) == 0) {
            return RelativePosition.ENDED_BY;
        }
        Date thisStart = thisPeriod.getBeginning().getPosition().getDate();
        if (thisStart.before(otherDate) && thisEnd.after(otherDate)) {
            return RelativePosition.CONTAINS;
        }
        return thisStart.compareTo(otherDate) == 0 ? RelativePosition.BEGUN_BY : RelativePosition.AFTER;
    }

    private RelativePosition relativePosition(Instant thisInstant, Instant otherIstant) {
        Date otherDate;
        Date thisDate = thisInstant.getPosition().getDate();
        if (thisDate.before(otherDate = otherIstant.getPosition().getDate())) {
            return RelativePosition.BEFORE;
        }
        return thisDate.compareTo(otherDate) == 0 ? RelativePosition.EQUALS : RelativePosition.AFTER;
    }
}

