(function(){
    'use strict';

    const requestInstanceAccess = {
        bindings: {
            request: '<',
            requester: '<',
            closer: '<',
            onChange: '&'
        },
        templateUrl: 'static/dataiku/inbox/components/request-center/request/request-instance-access/request-instance-access.component.html',
        controller: function($rootScope, DataikuAPI) {
            this.callback = () => {
                const response = {selectedUserProfile: this.selectedUserProfile, selectedProfileType: this.selectedProfileType, type: 'InstanceAccessResponse'}; // keep type in sync with backend
                this.onChange({response});
                if (!this.trialsDisabled && this.trialStatus && this.trialStatus.allocations) {
                    this.getRemainingTokensForProfile();
                    if (this.remainingTokensForProfile === 0) { this.selectedProfileType = "REGULAR";}
                }
            }

            this.getRemainingTokensForProfile = () => {
                const profileTrialStatus = this.trialStatus.allocations.filter(elt => elt.userProfile === this.selectedUserProfile);
                this.remainingTokensForProfile = profileTrialStatus.length > 0 && profileTrialStatus[0].mode === "TOTAL_CREDIT" ? profileTrialStatus[0].remainingCredit : undefined;
            }

            this.$onInit = () => {
                this.profileOptions = $rootScope.appConfig.licensing.userProfiles.filter(profile => profile !== "NONE");
                this.selectedProfileType = "REGULAR";
                this.selectedUserProfile = this.profileOptions[this.profileOptions.length -1];
                this.trialsDisabled = !$rootScope.appConfig.trialsEnabled || (this.requester.trialStatus && this.requester.trialStatus.exists);
                if (!this.trialsDisabled) {
                    DataikuAPI.admin.getTrialStatus().then((response) => {
                        this.trialStatus = response.data;
                        if (this.trialStatus && this.trialStatus.allocations) {
                            this.getRemainingTokensForProfile();
                        }
                    }).catch((e) => {this.trialStatus = undefined;});
                }
                this.callback();
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestInstanceAccess', requestInstanceAccess);
})();
