(function() {
    'use strict';

    angular.module('dataiku.dashboards').component('dashboardFilterDatasetColumnPicker', {
        bindings: {
            // inputs
            datasetSmartName: '<', // string
            columns: '<', // UsableColumn[]
            enableDatasetSelection: '<', // boolean
            // outputs
            selectColumns: '&', // ($columns) => void
            selectDataset: '&', // ($sourceObject, $sourceType, $selectedTile) => void
            cancelSelection: '&' // () => void
        },
        templateUrl:
      '/static/dataiku/js/dashboards/components/dashboard-filter-dataset-column-picker/dashboard-filter-dataset-column-picker.html',
        controller: function($stateParams, $scope, $rootScope, DashboardFilters, WT1) {
            const ctrl = this;
            ctrl.selectFromExistingTile = true;
            ctrl.filtersCompatibleTiles = DashboardFilters.getSlideFilterableTiles(
                $stateParams.pageId,
                $rootScope.topNav.item.data.pages
            );
            ctrl.selectedTile = undefined;
            ctrl.selectedTileId = undefined;
            ctrl.sourceObject = undefined;
            ctrl.isSourcePreselected = false;
            ctrl.sourceTypes = DashboardFilters.filtersSourceTypes;
            ctrl.source = ctrl.filtersCompatibleTiles.length ? ctrl.sourceTypes.TILE : ctrl.sourceTypes.DATASET;
            ctrl.selectedColumns = [];

            ctrl.$onChanges = (changes) => {
                if (changes.columns) {
                    ctrl.selectedColumns = [];
                }
            };

            $scope.$watch('$ctrl.sourceObject', function(nv) {
                if (!nv || (ctrl.source === ctrl.sourceTypes.TILE && ctrl.selectedTile == null)) {
                    return;
                }
                ctrl.selectDataset({ $sourceObject: nv, $sourceType: ctrl.source, $selectedTile: ctrl.selectedTile });
            });

            ctrl.setFilters = () => {
                ctrl.selectColumns({
                    $columns: ctrl.selectedColumns
                });
            };

            ctrl.cancel = () => {
                ctrl.cancelSelection();
            };
        }
    });
})();
