(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/core.js
     */
    app.controller('ProjectHomeDashboardListController', function($scope, $stateParams, DataikuAPI) {
        $scope.listHeads = DataikuAPI.dashboards.listSummaries($stateParams.projectKey).success(function(data) {
            $scope.dashboards = data.map(function(summary) {
                const dashboard = summary.object;
                dashboard.interest = summary.interest;
                dashboard.numTiles = 0;
                dashboard.pages.forEach(function(page) {
                    dashboard.numTiles += page.grid.tiles.length;
                });
                dashboard.numPages = dashboard.pages.length;
                return dashboard;
            });
        }).error(setErrorInScope.bind($scope));
    });
})();
