(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    /**
     * (!) This directive previously was in static/dataiku/js/simple_report/chart_dragdrop.js
     */
    app.directive('chartMultiDragDropZones', function(translate) {
        return {
            controller: 'ChartDragDropController',
            link: function($scope, element) {

                $scope.activeDragDrop = {};
                $scope.translate = translate;

                $scope.onDragEnd = function() {
                    // Unhide the moved element, as ng-repeat will reuse it
                    if ($scope.activeDragDrop.draggedElementToHide) {
                        $scope.activeDragDrop.draggedElementToHide.show();
                    }
                    clear($scope.activeDragDrop);
                    $scope.setDragInactive();
                };

                element[0].addEventListener('dragend', function(e) {
                    $scope.$apply($scope.onDragEnd);
                });
            }
        };
    });
})();
