(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This directive previously was in static/dataiku/js/simple_report/config_ui.js
    app.directive('monovaluedStdAggrMeasureZone', function($parse, ChartFeatures, ChartLabels, ChartCustomMeasures, ColorUtils, DefaultDSSVisualizationTheme) {
        return {
            templateUrl: '/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/monovalued-std-aggr-measure-zone/monovalued-std-aggr-measure-zone.directive.html',
            scope: true,
            link: function($scope, _element, attrs) {
                $scope.$watch(attrs.list, newList => $scope.list = newList);
                $scope.chartDefKey = attrs.chartDefKey;
                $scope.acceptCallback = $parse(attrs.acceptCallback)($scope);
                $scope.ChartFeatures = ChartFeatures;
                $scope.ChartLabels = ChartLabels;
                $scope.getAggregationFunctionDescription = ChartLabels.getAggregationFunctionDescription;
                $scope.countOfRecordsLabel = ChartLabels.COUNT_OF_RECORDS_LABEL;
                $scope.getAvailableAggregations = (measureType, chartType, contextualMenuMeasureType) => ChartLabels.getAvailableAggregationsLabels(measureType, chartType, contextualMenuMeasureType);
                $scope.getCustomMeasure = ChartCustomMeasures.getCustomMeasure;
                $scope.foregroundColors = [];
                $scope.themeColors = [];

                $scope.$watch(attrs.theme, (nv, ov) => {
                    $scope.theme = nv;
                    $scope.themeColors = ColorUtils.getThemeColorsWithBlackWhite($scope.theme);
                    if (nv && (!ov || !_.isEqual(nv.colors, ov.colors) || !$scope.foregroundColors.length)) {
                        const paletteColors = ColorUtils.generateThemePaletteColors(nv.colors, $scope.themeColors.length > 0);
                        if (paletteColors) {
                            $scope.foregroundColors = paletteColors.foregroundColors;
                        }
                    } else if (!nv) {
                        $scope.foregroundColors = ColorUtils.generateThemePaletteColors(DefaultDSSVisualizationTheme.colors, false).foregroundColors;
                    }
                    $scope.defaultFormatting = $scope.theme ? { fontColor: $scope.theme.generalFormatting.fontColor } : {};
                });

                $scope.assignToMeasure = function(data) {
                    _.set(data.measure, data.property, data.value);
                    if (!$scope.$$phase) {
                        $scope.$apply();
                    }
                };
                $scope.assignToFirstMeasure = function(property, value) {
                    _.set($scope.list[0], property, value);
                    if (!$scope.$$phase) {
                        $scope.$apply();
                    }
                };
            }
        };
    });
})();
