(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('_GeometryCommon', GeometryCommon);

    // (!) This service previously was in static/dataiku/js/simple_report/geometry/geometry_plot.js
    function GeometryCommon(ColorUtils, ChartColorScales, UaChartsCommon) {
        const svc = {
            hasUAColor: function(geoLayer) {
                return ((geoLayer.uaColor.length > 0) && (geoLayer.uaColor[0].column));
            },
            makeColorScale: function(geoLayer, data, chartHandler, geometryIndex) {
                const uaColor = geoLayer.uaColor[0];
                const colorTokenName = 'color_' + geometryIndex;
                const chartData = { data: data };
                const colorSpec = {
                    type: 'UNAGGREGATED',
                    dimension: uaColor,
                    data: data.values[colorTokenName],
                    withRgba: true
                };
                /** type: ChartColorContext */
                const colorContext = {
                    chartData,
                    colorOptions: geoLayer.colorOptions,
                    defaultLegendDimension: [],
                    colorSpec,
                    chartHandler,
                    uaColorIndex: geometryIndex,
                    theme: chartHandler.getChartTheme()
                };
                return ChartColorScales.createColorScale(colorContext);
            },
            makeSingleColor: function(geoLayer) {
                return ColorUtils.toRgba(geoLayer.colorOptions.singleColor, geoLayer.colorOptions.transparency);
            },

            makeColor: function(geoLayer, data, i, colorScale, resultingColor, colorCache, geometryIndex) {
                if (svc.hasUAColor(geoLayer)) {
                    const color = data.values['color_' + geometryIndex];
                    return ChartColorScales.getColor(geoLayer.uaColor, color, i, colorScale, colorCache);
                } else {
                    return resultingColor;
                }
            },
            formattedColorVal: function(chartDef, data, i, paletteName, geometryIndex) {
                let uaColor;
                if (typeof geometryIndex === 'undefined') {
                    uaColor = chartDef.uaColor[0];
                } else {
                    uaColor = chartDef.geoLayers[geometryIndex].uaColor[0];
                }
                paletteName = paletteName || 'color';
                return UaChartsCommon.formattedVal(data.values[paletteName], uaColor, i);
            },
            getDisplayableLayers: function(geoLayers) {
                let isLayerDisplayable;
                const displayableGeoLayers = [];
                for (const geoLayer of geoLayers.slice(0, -1)) {
                    isLayerDisplayable = (geoLayer.geometry && geoLayer.geometry.length && geoLayer.geometry[0].column);
                    if (isLayerDisplayable) {
                        displayableGeoLayers.push(geoLayer);
                    }
                }
                return displayableGeoLayers;
            }
        };
        return svc;
    }
})();
