 (function(){
 'use strict';

    angular.module("dataiku.nestedFilters").directive('inputTimeConversion', function ($timeout) {
        return {
            scope:false,
            restrict:'A',
            link: function($scope, element, attrs) {
                $scope.$watch(attrs.inputTimeConversion, function(nv) {
                    if (!nv) return;
                    var newVal = nv;
                    var curVal = $(element).val().substring(0,5)
                    if (curVal === newVal) return;
                    var date = new Date();
                    date.setMilliseconds(0);
                    date.setSeconds(0);
                    date.setHours(parseInt(newVal.substring(0,2)));
                    date.setMinutes(parseInt(newVal.substring(3,5)));
                    $scope[attrs.ngModel] = date;
                    $(element).val(newVal); // to avoid infinite digest
                    $timeout(function() {$(element).val(newVal);}); // because firefox likes to format time with full precision
                });
                $scope.$watch(attrs.ngModel, function(nv) {
                    if (!nv) return;
                    var newVal = $(element).val().substring(0,5)
                    var curVal = $scope.$eval(attrs.inputTimeConversion);
                    if (curVal === newVal) return;
                    $scope.$eval(attrs.inputTimeConversion + '="' + newVal + '"')
                });
            }
        };
    });
 })();