(function () {
    "use strict";
    angular.module("dataiku.opals").factory("HomeBannerService", HomeBannerService);

    function HomeBannerService(Assert, WT1, LocalStorage) {

        let homeBannerController = null;

        function registerHomeBannerController(controller) {
            homeBannerController = controller;
        }

        function assertHomeBannerContainer() {
          Assert.trueish(homeBannerController, "homeBannerContainer not registered");
        }

        function showHomeBanner(isImplicit) {
          assertHomeBannerContainer();
          homeBannerController.showBanner = true;
          if (!isImplicit) {
            WT1.event("opals-home-banner-show");
          }
          LocalStorage.set("dss.opalsHomeBanner.shown", true);
          homeBannerController.onBannerToggle(true);
        }

        function hideHomeBanner(isImplicit) {
          assertHomeBannerContainer();
          homeBannerController.showBanner = false;
          WT1.event("opals-home-banner-hide", { isImplicit: !!isImplicit });
          LocalStorage.set("dss.opalsHomeBanner.shown", false);
          homeBannerController.onBannerToggle(false);
        }

        return {
            registerHomeBannerController,
            showHomeBanner,
            hideHomeBanner,
        };
    }
})();
