from govern.core.migration_handler import get_migration_handler

handler = get_migration_handler()
### Get the artifact to migrate
target_artifact = handler.target_artifact
### Get the source enriched artifact
source_enriched_artifact = handler.source_enriched_artifact
### Get the target blueprint version definition
target_blueprint_version = handler.target_blueprint_version

### -------------------------------
### Using logging to debug this script
### You can use the logger instance to log info that will be printed in the governserver.log files

# import logging
# logging.basicConfig(level=logging.INFO)
# logger = logging.getLogger(__name__)
# logger.warning('here is a warning')
# logger.info('here an info message')

### -------------------------------
### The target_artifact variable contains the content of the artifact before the migration
### Modify it in place to apply the migration. 
### Once the script is executed target_artifact will be saved with the new template. 
### Edit the name of the artifact during the migration

# target_artifact.name = target_artifact.name + '_migrated'

### -------------------------------
### Edit the fields

# fields = target_artifact.fields
# fields['new_field'] = 'value'

### If you provide a field that is not present in the target blueprint version definition, the migration will fail.
### Also make sure to fill all required fields of the target definition.

### -------------------------------
### Use source_enriched_artifact to get the current existing item.

### For instance, if you wish to transfer the value of a string field from the old item into the new migrated one with a transformation:

# my_old_field_value = source_enriched_artifact.artifact.fields.get('my_old_field', '')
# transformed_value = my_old_field_value.replace('bananas', 'apples')
# target_artifact.fields['my_new_field'] = transformed_value

### -------------------------------
### Use the public api and retrieve the content of an artifact:
### Warning: do not use any side-effect api calls (artifact create, save, delete) because the migration is a pre-save script

# artifact = handler.client.get_artifact("ar.1773")
